package com.atlassian.crowd.manager.sso;

import java.security.cert.X509Certificate;
import java.util.Optional;

/**
 * A service for managing pairs of certificate and private key used in SSO.
 *
 * @since 3.4.0
 */
public interface SamlSSOCertificateService {
    /**
     * Generates and stores new pair of certificate and private key both 4096 bits long.
     * RSA algorithm is used to generate this pair.
     *
     * @return id of the newly-generated certificate and private key
     */
    long generateCertificateAndPrivateKey();

    /**
     * @param certificateId the id of the certificate to fetch
     * @return certificate based on passed id if found, none otherwise
     */
    Optional<X509Certificate> getCertificate(long certificateId);
}