package com.atlassian.crowd.manager.mail;

/**
 * Represents a result of sending a test email using MailManager.
 *
 * @since v3.2.0
 */
public class SendTestMailResult {

    private final String debugLogs;
    private final boolean success;

    public SendTestMailResult(String debugLogs, boolean messageSent) {
        this.debugLogs = debugLogs;
        this.success = messageSent;
    }

    /**
     * @return logs about connecting to mail server and sending message.
     */
    public String getDebugLogs() {
        return debugLogs;
    }

    /**
     * @return true if the test went correctly and the message was sent.
     */
    public boolean isSuccess() {
        return success;
    }
}
