package com.atlassian.crowd.manager.permission;

import com.atlassian.crowd.search.query.entity.EntityQuery;

import java.util.Objects;

/**
 * Encapsulates a query for groups administered by a user. Consists of both the search terms, as well as the paging
 * controls.
 *
 * @since 3.3.0
 */
public class AdministeredGroupsQuery {
    public static AdministeredGroupsQuery ALL_RESULTS_QUERY = allResults(null, null);

    private final Long directoryId;
    private final String search;
    private final int start;
    private final int limit;

    public AdministeredGroupsQuery(Long directoryId, String search, int start, int limit) {
        this.directoryId = directoryId;
        this.search = search;
        this.start = start;
        this.limit = limit;
    }

    public static AdministeredGroupsQuery allResults(Long directoryId, String search) {
        return new AdministeredGroupsQuery(directoryId, search, 0, EntityQuery.ALL_RESULTS);
    }

    public Long getDirectoryId() {
        return directoryId;
    }

    public String getSearch() {
        return search;
    }

    public int getStart() {
        return start;
    }

    public int getLimit() {
        return limit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdministeredGroupsQuery that = (AdministeredGroupsQuery) o;
        return start == that.start &&
                limit == that.limit &&
                Objects.equals(directoryId, that.directoryId) &&
                Objects.equals(search, that.search);
    }

    @Override
    public int hashCode() {
        return Objects.hash(directoryId, search, start, limit);
    }
}
