package com.atlassian.crowd.manager.authentication;

import com.atlassian.crowd.manager.rememberme.CrowdSpecificRememberMeSettings;

import java.time.Duration;
import java.util.Objects;

public class ImmutableCrowdSpecificRememberMeSettings implements CrowdSpecificRememberMeSettings {
    private final boolean enabled;
    private final Duration expirationPeriod;

    public ImmutableCrowdSpecificRememberMeSettings(boolean enabled, Duration expirationPeriod) {
        this.enabled = enabled;
        this.expirationPeriod = expirationPeriod;
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    @Override
    public Duration getExpirationDuration() {
        return expirationPeriod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImmutableCrowdSpecificRememberMeSettings that = (ImmutableCrowdSpecificRememberMeSettings) o;
        return enabled == that.enabled &&
                Objects.equals(expirationPeriod, that.expirationPeriod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(enabled, expirationPeriod);
    }
}
