package com.atlassian.crowd.manager.audit;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogEventSource;

import javax.annotation.Nullable;

/**
 * Resolves the common properties for the audit log changeset - the author and the current request's address
 */
@Internal
public interface AuditLogMetadataResolver {

    /**
     * @return the currently authenticated user/application to set as the author of an auditable action
     */
    AuditLogAuthor resolveAuthor();

    /**
     * @return the IP address from the current request or null if no request is currently ongoing. This method takes
     * the trusted proxy settings into account.
     */
    @Nullable
    String resolveIpAddress();

    /**
     * @return the source that should be used for auditing the current event
     */
    AuditLogEventSource resolveSource();
}
