package com.atlassian.crowd.web;

import javax.servlet.http.HttpServletRequest;

/**
 * Utility class that returns the base URL of the running Crowd/Horde server.
 */
public final class BaseUrlLocator {
    /**
     * @param request the HTTP request to get the base URL from
     * @return the base URL where the product is installed
     */
    public static String getBaseUrlFrom(HttpServletRequest request) {
        StringBuilder baseUrl = new StringBuilder(32);
        baseUrl.append(request.getScheme());
        baseUrl.append("://");
        baseUrl.append(request.getServerName());
        if (!isStandardPort(request.getScheme(), request.getServerPort())) {
            baseUrl.append(":");
            baseUrl.append(request.getServerPort());
        }
        baseUrl.append(request.getContextPath());
        return baseUrl.toString();
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase("http") && port == 80) return true;
        if (scheme.equalsIgnoreCase("https") && port == 443) return true;
        return false;
    }
}
