package com.atlassian.crowd.service.cluster;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Allows sending short cross-node messages.
 *
 * @since 3.0
 */
@ExperimentalApi
public interface ClusterMessageService {
    /**
     * Register a listener on a channel.
     */
    void registerListener(ClusterMessageListener listener, String channel);

    /**
     * Unregister a listener from a specific channel.
     */
    void unregisterListener(ClusterMessageListener listener, String channel);

    /**
     * Unregister a listener from all channels.
     */
    void unregisterListener(ClusterMessageListener listener);

    /**
     * Send a message to other nodes (excluding the sender), notifying all listeners on a specific channel.
     *
     * @param channel channel name, max. 64 characters.
     * @param message message content, max. 1024 characters.
     * @throws IllegalArgumentException if channel or message are too long.
     */
    void publish(String channel, String message);
}
