package com.atlassian.crowd.manager.permission;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;

/**
 * A class which inheritors can extend to create mappings of some entities to groups they can be administrators of
 * @since 3.3.0
 */
public abstract class GroupAdministrationMapping {
    protected final ImmutableGroup targetGroup;

    public GroupAdministrationMapping(Group targetGroup) {
        this.targetGroup = ImmutableGroup.from(targetGroup);
    }

    public Group getTargetGroup() {
        return targetGroup;
    }
}
