/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.GroupsResourceTest;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.NamedEntity;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.RenameEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class UsersResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String USERNAME_PARAM = "username";
    private static final String ATTRIBUTE_NAME_PARAM = "attributename";
    private static final String KEY_PARAM = "key";
    private static final String NEW_USERNAME_PARAM = "new-username";
    private static final String EXTERNAL_ID = "externalId";
    private static final String EXTERNAL_ID_WITH_DIRECTORY = "2:externalId";
    private static final String ALIASES_APPLICATION_NAME = "aliases";
    private static final String ALIASES_APPLICATION_PASSWORD = "aliases";

    public UsersResourceTest(String name) {
        super(name);
    }

    public UsersResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetUser() {
        URI uri = this.userResourceByNameUri("admin");
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UsersResourceTest.assertIsBobTheBuilder(webResource);
        UsersResourceTest.assertEquals((Object)this.userResourceByNameUri("admin"), (Object)((UserEntity)webResource.get(UserEntity.class)).getLink().getHref());
    }

    public void testGetUserByKey() {
        URI uri = this.userResourceByKeyUri(EXTERNAL_ID_WITH_DIRECTORY);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UsersResourceTest.assertIsBobTheBuilder(webResource);
        UsersResourceTest.assertEquals((Object)this.userResourceByNameUri("admin"), (Object)((UserEntity)webResource.get(UserEntity.class)).getLink().getHref());
    }

    private URI userResourceByNameUri(String username) {
        return this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{username});
    }

    private URI userResourceByKeyUri(String key) {
        return this.getBaseUriBuilder().path("user").queryParam(KEY_PARAM, new Object[]{"{key}"}).build(new Object[]{key});
    }

    private static void assertIsBobTheBuilder(WebResource webResource) {
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertEquals((String)"admin", (String)user.getName());
        UsersResourceTest.assertEquals((String)"bob", (String)user.getFirstName());
        UsersResourceTest.assertEquals((String)"the builder", (String)user.getLastName());
        UsersResourceTest.assertEquals((String)"bob the builder", (String)user.getDisplayName());
        UsersResourceTest.assertEquals((String)"bob@example.net", (String)user.getEmail());
        UsersResourceTest.assertEquals((String)EXTERNAL_ID_WITH_DIRECTORY, (String)user.getKey());
        UsersResourceTest.assertTrue((boolean)user.isActive());
    }

    public void testGetUser_InvalidApplicationCredentials() {
        String INVALID_PASSWORD = "InvalidPassword";
        URI uri = this.userResourceByNameUri("admin");
        WebResource webResource = this.getWebResource("crowd", "InvalidPassword", uri);
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)clientResponse.getClientResponseStatus());
    }

    public void testGetUser_NonExistent() {
        String NON_EXISTENT_USER = "nonexistent";
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"nonexistent"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)clientResponse.getClientResponseStatus());
    }

    public void testGetUserWithAttributes() {
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("expand", new Object[]{"attributes"}).build(new Object[]{"admin"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UsersResourceTest.assertValidUserWithAttributes(webResource);
        UsersResourceTest.assertEquals((Object)this.userResourceByNameUri("admin"), (Object)((UserEntity)webResource.get(UserEntity.class)).getLink().getHref());
    }

    public void testGetUserWithAttributesByKey() {
        URI uri = this.getBaseUriBuilder().path("user").queryParam(KEY_PARAM, new Object[]{"{key}"}).queryParam("expand", new Object[]{"attributes"}).build(new Object[]{EXTERNAL_ID_WITH_DIRECTORY});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UsersResourceTest.assertValidUserWithAttributes(webResource);
        UsersResourceTest.assertEquals((Object)this.userResourceByNameUri("admin"), (Object)((UserEntity)webResource.get(UserEntity.class)).getLink().getHref());
    }

    private static void assertValidUserWithAttributes(WebResource webResource) {
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertEquals((String)"admin", (String)user.getName());
        UsersResourceTest.assertEquals((String)"bob", (String)user.getFirstName());
        UsersResourceTest.assertEquals((String)"the builder", (String)user.getLastName());
        UsersResourceTest.assertEquals((String)"bob the builder", (String)user.getDisplayName());
        UsersResourceTest.assertEquals((String)"bob@example.net", (String)user.getEmail());
        UsersResourceTest.assertEquals((String)EXTERNAL_ID_WITH_DIRECTORY, (String)user.getKey());
        UsersResourceTest.assertTrue((boolean)user.isActive());
        MultiValuedAttributeEntityList attributeList = user.getAttributes();
        UsersResourceTest.assertNotNull((Object)attributeList);
        HashSet attributeNames = Sets.newHashSet();
        for (MultiValuedAttributeEntity attribute : attributeList) {
            attributeNames.add(attribute.getName());
        }
        HashSet expectedAttributeNames = Sets.newHashSet((Object[])new String[]{"passwordLastChanged", "invalidPasswordAttempts", "lastAuthenticated", "requiresPasswordChange"});
        UsersResourceTest.assertEquals((Object)expectedAttributeNames, (Object)attributeNames);
    }

    public void testAddUser() throws Exception {
        this.intendToModifyData();
        String NEW_USERNAME = "newuser";
        String NEW_USER_PASSWORD = "secret";
        URI uri = this.getBaseUriBuilder().path("user").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserTemplate userTemplate = new UserTemplate("newuser");
        userTemplate.setActive(true);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        UserEntity userEntity = EntityTranslator.toUserEntity((User)userTemplate, (Link)Link.self((URI)URI.create("link_to_user")));
        PasswordEntity passwordEntity = new PasswordEntity("secret", null);
        userEntity.setPassword(passwordEntity);
        UserEntity newUserEntity = (UserEntity)webResource.entity((Object)userEntity, MT).post(UserEntity.class);
        UsersResourceTest.assertEquals((String)"newuser", (String)newUserEntity.getName());
        UsersResourceTest.assertNotNull((String)"An identifier should be generated for the user", (Object)newUserEntity.getKey());
        this.authenticateUser("newuser", "secret", "aliases", "aliases");
    }

    public void testAddUser_NoPasswordProvided() {
        URI uri = this.getBaseUriBuilder().path("user").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserTemplate userTemplate = new UserTemplate("newuser");
        userTemplate.setActive(true);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        UserEntity userEntity = EntityTranslator.toUserEntity((User)userTemplate, (Link)Link.self((URI)URI.create("link_to_user")));
        ClientResponse clientResponse = (ClientResponse)webResource.entity((Object)userEntity, MT).post(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)clientResponse.getClientResponseStatus());
    }

    public void testAddUser_AtlassianSecurityPasswordProvided() {
        this.intendToModifyData();
        String NEW_USERNAME = "newuser";
        String NEW_USER_PASSWORD = "secret_to_be_hashed";
        URI uri = this.getBaseUriBuilder().path("user").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserTemplate userTemplate = new UserTemplate("newuser");
        userTemplate.setActive(true);
        userTemplate.setDisplayName("New User via REST");
        userTemplate.setFirstName("New");
        userTemplate.setLastName("User");
        userTemplate.setEmailAddress("newuser@example.com");
        PasswordEncoder passwordEncoder = DefaultPasswordEncoder.getDefaultInstance();
        String encodedPassword = passwordEncoder.encodePassword("secret_to_be_hashed");
        UserEntity userEntity = EntityTranslator.toUserEntity((User)userTemplate, (Link)Link.self((URI)URI.create("link_to_user")));
        PasswordEntity passwordEntity = new PasswordEntity(encodedPassword, null);
        userEntity.setEncryptedPassword(passwordEntity);
        webResource.entity((Object)userEntity, MT).post();
        this.authenticateUser("newuser", "secret_to_be_hashed", "aliases", "aliases");
    }

    public void testUpdateUser() {
        this.intendToModifyData();
        String NEW_EMAIL = "eeeep@example.net";
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        user.setEmail("eeeep@example.net");
        user.setActive(false);
        webResource.entity((Object)user, MT).put();
        UserEntity updatedUser = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertEquals((String)"eeeep@example.net", (String)updatedUser.getEmail());
        UsersResourceTest.assertFalse((boolean)updatedUser.isActive());
    }

    public void testUpdateUser_WrongUserUri() {
        String USERNAME = "eeeep";
        String ANOTHER_USERNAME = "meeep";
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        user.setName("meeep");
        ClientResponse clientResponse = (ClientResponse)webResource.entity((Object)user, MT).put(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)clientResponse.getClientResponseStatus());
    }

    public void testUpdateUserWithDifferentCaseInUrlIsAccepted() {
        this.intendToModifyData();
        String NEW_EMAIL = "eeeep@example.net";
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"Eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        user.setEmail("eeeep@example.net");
        webResource.entity((Object)user, MT).put();
        UserEntity updatedUser = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertEquals((String)"eeeep@example.net", (String)updatedUser.getEmail());
    }

    public void testUpdateUserWithDifferentCaseInEntityIsAccepted() {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        user.setName("Eeeep");
        webResource.entity((Object)user, MT).put();
        UserEntity updatedUser = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertEquals((String)"eeeep", (String)updatedUser.getName());
    }

    public void testUpdateUserWithDifferentEntityNameShouldNotRenameUser() {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        user.setName("renamed");
        ClientResponse response = (ClientResponse)webResource.entity((Object)user, MT).put(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        UserEntity updatedUser = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertEquals((String)"eeeep", (String)updatedUser.getName());
    }

    public void testRenameUserShouldRenameUserWhenProvidedWithOldUsername() {
        this.doTestRenameUser("eeeep", "screech");
    }

    public void testRenameUserShouldRenameUserWhenProvidedWithOldUsernameAndNewNameOfDifferentCase() {
        this.doTestRenameUser("eeeep", "Eeeep");
    }

    private void doTestRenameUser(String oldName, String newName) {
        this.intendToModifyData();
        UserEntity originalUser = (UserEntity)this.getWebResource("crowd", "qybhDMZh", this.userResourceByNameUri(oldName)).get(UserEntity.class);
        UsersResourceTest.assertNotNull((String)"key must be non-null in order to check that rename worked", (Object)originalUser.getKey());
        URI uri = this.getBaseUriBuilder().path("user").path("rename").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{originalUser.getName()});
        WebResource renameWebResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity renamedUser = (UserEntity)renameWebResource.entity((Object)new RenameEntity(newName)).post(UserEntity.class);
        UsersResourceTest.assertEquals((String)newName, (String)renamedUser.getName());
        UsersResourceTest.assertEquals((String)originalUser.getKey(), (String)renamedUser.getKey());
        UserEntity userFetchedByKeyAfterRename = (UserEntity)this.getWebResource("crowd", "qybhDMZh", this.userResourceByKeyUri(originalUser.getKey())).get(UserEntity.class);
        UsersResourceTest.assertEquals((String)newName, (String)userFetchedByKeyAfterRename.getName());
        UsersResourceTest.assertEquals((String)originalUser.getKey(), (String)userFetchedByKeyAfterRename.getKey());
        UsersResourceTest.assertEquals((Object)(IdentifierUtils.equalsInLowerCase((String)oldName, (String)newName) ? ClientResponse.Status.OK : ClientResponse.Status.NOT_FOUND), (Object)((ClientResponse)this.getWebResource("crowd", "qybhDMZh", this.userResourceByNameUri(originalUser.getName())).get(ClientResponse.class)).getClientResponseStatus());
        UserEntity userFetchedByNewNameAfterRename = (UserEntity)this.getWebResource("crowd", "qybhDMZh", this.userResourceByNameUri(newName)).get(UserEntity.class);
        UsersResourceTest.assertEquals((String)newName, (String)userFetchedByNewNameAfterRename.getName());
        UsersResourceTest.assertEquals((String)originalUser.getKey(), (String)userFetchedByNewNameAfterRename.getKey());
    }

    public void testRenameUserShouldFailWhenUserWithProvidedUsernameDoesNotExist() {
        String username = "nonexistentuser";
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)((ClientResponse)this.getWebResource("crowd", "qybhDMZh", this.userResourceByNameUri("nonexistentuser")).get(ClientResponse.class)).getClientResponseStatus());
        URI uri = this.getBaseUriBuilder().path("user").path("rename").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"nonexistentuser"});
        ClientResponse renameResponse = (ClientResponse)this.getWebResource("crowd", "qybhDMZh", uri).entity((Object)new RenameEntity("nonexistentuser2")).post(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)renameResponse.getClientResponseStatus());
        ErrorEntity error = (ErrorEntity)renameResponse.getEntity(ErrorEntity.class);
        UsersResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.USER_NOT_FOUND, (Object)error.getReason());
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"User <nonexistentuser> does not exist"));
    }

    public void testRenameUserShouldFailWhenNewUsernameIsAlreadyInUse() {
        String userA = "eeeep";
        String userB = "admin";
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.OK, (Object)((ClientResponse)this.getWebResource("crowd", "qybhDMZh", this.userResourceByNameUri("admin")).get(ClientResponse.class)).getClientResponseStatus());
        URI uri = this.getBaseUriBuilder().path("user").path("rename").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        ClientResponse renameResponse = (ClientResponse)this.getWebResource("crowd", "qybhDMZh", uri).entity((Object)new RenameEntity("admin")).post(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Object)renameResponse.getClientResponseStatus());
        ErrorEntity error = (ErrorEntity)renameResponse.getEntity(ErrorEntity.class);
        UsersResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.OPERATION_FAILED, (Object)error.getReason());
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"User admin already exists"));
    }

    public void testUpdateUserPassword() {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("user").path("password").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"secondadmin"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        webResource.put((Object)new PasswordEntity("newpassword", null));
        UsersResourceTest.assertNotNull((Object)this.authenticateUser("secondadmin", "newpassword"));
    }

    public void testDeleteUserPasswordRejectsOldPassword() {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("user").path("password").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        webResource.delete();
        try {
            this.authenticateUser("eeeep", "eep");
            UsersResourceTest.fail((String)"Should have thrown");
        }
        catch (UniformInterfaceException uniformInterfaceException) {
            // empty catch block
        }
    }

    public void testStoreUserAttributes() {
        this.intendToModifyData();
        String ATTRIB1_NAME = "favourite-colour";
        String ATTRIB1_VALUE = "green";
        String ATTRIB2_NAME = "favourite-animals";
        String ATTRIB2_VALUE1 = "Tapirus terrestris";
        String ATTRIB2_VALUE2 = "Suricata suricatta";
        URI uri = this.getBaseUriBuilder().path("user").path("attribute").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"secondadmin"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        MultiValuedAttributeEntityList attributeListBefore = (MultiValuedAttributeEntityList)webResource.get(MultiValuedAttributeEntityList.class);
        Map<String, Set<String>> expectedAttributes = UsersResourceTest.toAttributesMap(attributeListBefore);
        expectedAttributes.put("favourite-colour", Sets.newHashSet((Object[])new String[]{"green"}));
        expectedAttributes.put("favourite-animals", Sets.newHashSet((Object[])new String[]{"Tapirus terrestris", "Suricata suricatta"}));
        MultiValuedAttributeEntity attrib1 = new MultiValuedAttributeEntity("favourite-colour", (Collection)Sets.newHashSet((Object[])new String[]{"green"}), null);
        MultiValuedAttributeEntity attrib2 = new MultiValuedAttributeEntity("favourite-animals", (Collection)Sets.newHashSet((Object[])new String[]{"Tapirus terrestris", "Suricata suricatta"}), null);
        MultiValuedAttributeEntityList attributes = new MultiValuedAttributeEntityList(Arrays.asList(attrib1, attrib2), null);
        webResource.entity((Object)attributes, MT).post();
        MultiValuedAttributeEntityList userAttributes = (MultiValuedAttributeEntityList)webResource.get(MultiValuedAttributeEntityList.class);
        Map<String, Set<String>> actualAttributes = UsersResourceTest.toAttributesMap(userAttributes);
        UsersResourceTest.assertEquals(expectedAttributes, actualAttributes);
    }

    public void testDeleteUserAttribute() {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("user").path("attribute").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam(ATTRIBUTE_NAME_PARAM, new Object[]{"{attributename}"}).build(new Object[]{"secondadmin", "passwordLastChanged"});
        WebResource passwordLastChangedWR = this.getWebResource("crowd", "qybhDMZh", uri);
        passwordLastChangedWR.delete();
        URI attributesUri = this.getBaseUriBuilder().path("user").path("attribute").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"secondadmin"});
        WebResource attributesWebResource = this.getWebResource("crowd", "qybhDMZh", attributesUri);
        MultiValuedAttributeEntityList attributes = (MultiValuedAttributeEntityList)attributesWebResource.get(MultiValuedAttributeEntityList.class);
        for (MultiValuedAttributeEntity attribute : attributes) {
            if (!"passwordLastChanged".equals(attribute.getName())) continue;
            UsersResourceTest.fail((String)"Attribute passwordLastChanged not deleted.");
        }
    }

    public void testDeleteNonExistentUserAttributeSucceeds() {
        URI uri = this.getBaseUriBuilder().path("user").path("attribute").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam(ATTRIBUTE_NAME_PARAM, new Object[]{"{attributename}"}).build(new Object[]{"secondadmin", "no-attribute-with-this-name"});
        this.getWebResource("crowd", "qybhDMZh", uri).delete();
    }

    public void testDeleteUser() {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"dir1user"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        UserEntity userEntity = (UserEntity)webResource.get(UserEntity.class);
        UsersResourceTest.assertNotNull((Object)userEntity);
        webResource.delete();
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)clientResponse.getClientResponseStatus());
        ErrorEntity errorEntity = (ErrorEntity)clientResponse.getEntity(ErrorEntity.class);
        UsersResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.USER_NOT_FOUND, (Object)errorEntity.getReason());
    }

    public void testAddUserToGroup() {
        this.intendToModifyData();
        String GROUP_NAME = "crowd-administrators";
        URI groupMembershipUri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("groupname", new Object[]{"{groupname}"}).build(new Object[]{"eeeep", "crowd-administrators"});
        WebResource groupMembershipWebResource = this.getWebResource("crowd", "qybhDMZh", groupMembershipUri);
        ClientResponse clientResponse = (ClientResponse)groupMembershipWebResource.get(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)clientResponse.getClientResponseStatus());
        ErrorEntity errorEntity = (ErrorEntity)clientResponse.getEntity(ErrorEntity.class);
        UsersResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND, (Object)errorEntity.getReason());
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = GroupEntity.newMinimalGroupEntity((String)"crowd-administrators", (String)"crowd", (URI)URI.create("random"));
        webResource.entity((Object)groupEntity, MT).post();
        GroupEntity newGroupEntity = (GroupEntity)groupMembershipWebResource.get(GroupEntity.class);
        UsersResourceTest.assertEquals((String)"crowd-administrators", (String)newGroupEntity.getName());
    }

    public void testAddUserToGroup_NonExistentGroup() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"secondadmin"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = GroupEntity.newMinimalGroupEntity((String)"non-existent-group", (String)"crowd", (URI)URI.create("random"));
        ClientResponse clientResponse = (ClientResponse)webResource.entity((Object)groupEntity, MT).post(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)clientResponse.getClientResponseStatus());
        ErrorEntity errorEntity = (ErrorEntity)clientResponse.getEntity(ErrorEntity.class);
        UsersResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.GROUP_NOT_FOUND, (Object)errorEntity.getReason());
    }

    public void testAddUserToGroup_NonExistentUser() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"non-existent-user"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = GroupEntity.newMinimalGroupEntity((String)"crowd-administrators", (String)"crowd", (URI)URI.create("random"));
        ClientResponse clientResponse = (ClientResponse)webResource.entity((Object)groupEntity, MT).post(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)clientResponse.getClientResponseStatus());
    }

    public void testAddUserToGroup_MembershipAlreadyExists() {
        String GROUP_NAME = "badgers";
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = GroupEntity.newMinimalGroupEntity((String)"badgers", (String)"crowd", (URI)URI.create("random"));
        ClientResponse clientResponse = (ClientResponse)webResource.entity((Object)groupEntity, MT).post(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.CONFLICT, (Object)clientResponse.getClientResponseStatus());
    }

    public void testRemoveUserFromGroup() {
        this.intendToModifyData();
        String USER_NAME = "eeeep";
        String GROUP_NAME = "crowd-administrators";
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"eeeep"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = GroupEntity.newMinimalGroupEntity((String)"crowd-administrators", (String)"crowd", (URI)URI.create("random"));
        webResource.entity((Object)groupEntity, MT).post();
        URI groupMemberUri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("groupname", new Object[]{"{groupname}"}).build(new Object[]{"eeeep", "crowd-administrators"});
        WebResource groupMemberWebResource = this.getWebResource("crowd", "qybhDMZh", groupMemberUri);
        GroupEntity newGroupEntity = (GroupEntity)groupMemberWebResource.get(GroupEntity.class);
        UsersResourceTest.assertEquals((String)"crowd-administrators", (String)newGroupEntity.getName());
        groupMemberWebResource.delete();
        ClientResponse clientResponse = (ClientResponse)groupMemberWebResource.get(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)clientResponse.getClientResponseStatus());
        ErrorEntity errorEntity = (ErrorEntity)clientResponse.getEntity(ErrorEntity.class);
        UsersResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND, (Object)errorEntity.getReason());
    }

    public void testGetNestedGroup() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("nested").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("groupname", new Object[]{"{groupname}"}).build(new Object[]{"penny", "crowd-administrators"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = (GroupEntity)webResource.get(GroupEntity.class);
        UsersResourceTest.assertEquals((String)"crowd-administrators", (String)groupEntity.getName());
    }

    public void testGetNestedGroups() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("nested").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"admin"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntityList groupEntityList = (GroupEntityList)webResource.get(GroupEntityList.class);
        Set<String> groupNames = GroupsResourceTest.namesOf((Iterable<? extends NamedEntity>)groupEntityList);
        HashSet expectedNames = Sets.newHashSet((Object[])new String[]{"badgers", "crowd-administrators", "crowd-testers", "crowd-users"});
        UsersResourceTest.assertEquals((Object)expectedNames, groupNames);
    }

    public void testGetDirectGroup() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("groupname", new Object[]{"{groupname}"}).build(new Object[]{"admin", "badgers"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = (GroupEntity)webResource.get(GroupEntity.class);
        UsersResourceTest.assertEquals((String)"badgers", (String)groupEntity.getName());
    }

    public void testGetDirectGroups() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{"admin"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntityList groupEntityList = (GroupEntityList)webResource.get(GroupEntityList.class);
        Set<String> groupNames = GroupsResourceTest.namesOf((Iterable<? extends NamedEntity>)groupEntityList);
        HashSet expectedNames = Sets.newHashSet((Object[])new String[]{"badgers", "crowd-administrators"});
        UsersResourceTest.assertEquals((Object)expectedNames, groupNames);
    }

    public void testGetNestedGroup_NonExistentGroupMembership() {
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("nested").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("groupname", new Object[]{"{groupname}"}).build(new Object[]{"penny", "crowd-users"});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        UsersResourceTest.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)clientResponse.getClientResponseStatus());
    }

    private static Map<String, Set<String>> toAttributesMap(MultiValuedAttributeEntityList attributeEntityList) {
        HashMap result = Maps.newHashMap();
        for (MultiValuedAttributeEntity attributeEntity : attributeEntityList) {
            HashSet attributeValues = new HashSet(attributeEntity.getValues());
            result.put(attributeEntity.getName(), attributeValues);
        }
        return result;
    }
}

