/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;

public class UserPermissionAdminResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    protected static final String ANIMALS = "animals";
    protected static final String BADGERS = "badgers";
    protected static final String BIRDS = "birds";
    protected static final String CATS = "cats";
    protected static final String CROWD_ADMINS = "crowd-administrators";
    protected static final String CROWD_TESTERS = "crowd-testers";
    protected static final String CROWD_USERS = "crowd-users";
    protected static final String DOGS = "dogs";
    protected static final Long DIRECTORY1_ID = 2L;
    protected static final Long DIRECTORY2_ID = 1L;
    protected static final String DIRECTORY1_NAME = "Directory One";
    protected static final String DIRECTORY2_NAME = "Directory Two";
    public static final String ANON_PERMISSION_DENIED = "You must log in again in order to perform this action.";
    public static final String USER_PERMISSION_DENIED = "You have insufficient permissions to view permitted groups.";
    public static final String ADMIN_USER = "admin";
    public static final String ADMIN_PW = "admin";
    public static final String USERNAME_PARAM = "username";

    public UserPermissionAdminResourceTest(String name) {
        super(name);
    }

    public UserPermissionAdminResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testAnonCanNotListPermissions() throws Exception {
        UserPermissionAdminResourceTest.assertPermissionDenied(ANON_PERMISSION_DENIED, this.callRestEndpoint(Method.GET, "", null, null, null));
    }

    public void testAnonCanNotGrantPermissions() throws Exception {
        UserPermissionAdminResourceTest.assertPermissionDenied(ANON_PERMISSION_DENIED, this.callRestEndpoint(Method.PUT, "", (Map<String, String>)ImmutableMap.of((Object)"permission", (Object)UserPermission.SYS_ADMIN.name()), UserPermissionAdminResourceTest.buildGroups(UserPermissionAdminResourceTest.buildGroup(CROWD_ADMINS, DIRECTORY1_ID)), null));
    }

    public void testAnonCanNotRevokePermissions() throws Exception {
        UserPermissionAdminResourceTest.assertPermissionDenied(ANON_PERMISSION_DENIED, this.callRestEndpoint(Method.POST, "/revoke", null, UserPermissionAdminResourceTest.buildGroup(CROWD_ADMINS, DIRECTORY1_ID), null));
    }

    public void testAnonCanNotListGroups() throws Exception {
        UserPermissionAdminResourceTest.assertPermissionDenied(ANON_PERMISSION_DENIED, this.callRestEndpoint(Method.GET, "/groups", null, null, null));
    }

    public void testCannotRevokeOwnRights() throws Exception {
        JSONObject data = new JSONObject("{'group-name':'crowd-administrators','directory-id':" + DIRECTORY1_ID + "}");
        UserPermissionAdminResourceTest.assertPermissionDenied("You cannot revoke the permission of group crowd-administrators as it would downgrade your own permissions.", this.callRestEndpoint(Method.POST, "/revoke", null, data, (Credentials)new UsernamePasswordCredentials("admin", "admin")));
    }

    public void testListPermissions() throws Exception {
        Pair<Integer, JSONObject> restResponse = this.callRestEndpoint(Method.GET, "", null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)200, (int)((Integer)restResponse.getLeft()));
        JSONObject response = (JSONObject)restResponse.getRight();
        Assert.assertThat(UserPermissionAdminResourceTest.getKeysAsList(response), (Matcher)Matchers.hasItems((Object[])new String[]{"last-page", "limit", "results", "size", "start"}));
        List<GroupData> expectedGroups = this.expectedGroupsForTestListPermissions();
        UserPermissionAdminResourceTest.assertTrue((boolean)response.getBoolean("last-page"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("limit"));
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)response.getInt("size"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("start"));
        JSONArray results = response.getJSONArray("results");
        UserPermissionAdminResourceTest.assertPermittedGroups(results, expectedGroups);
    }

    protected List<GroupData> expectedGroupsForTestListPermissions() {
        return ImmutableList.of((Object)new GroupData(UserPermission.SYS_ADMIN, CROWD_ADMINS, DIRECTORY1_ID, DIRECTORY1_NAME));
    }

    public void testListGroups() throws Exception {
        Pair<Integer, JSONObject> restResponse = this.callRestEndpoint(Method.GET, "/groups", null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)200, (int)((Integer)restResponse.getLeft()));
        JSONObject response = (JSONObject)restResponse.getRight();
        List<GroupData> expectedGroups = this.expectedGroupsForTestListGroups();
        JSONArray results = response.getJSONArray("results");
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)results.length());
        UserPermissionAdminResourceTest.assertTrue((boolean)response.getBoolean("last-page"));
        UserPermissionAdminResourceTest.assertGroups(results, expectedGroups);
    }

    protected List<GroupData> expectedGroupsForTestListGroups() {
        return ImmutableList.of((Object)new GroupData(null, BADGERS, DIRECTORY1_ID, DIRECTORY1_NAME), (Object)new GroupData(null, CROWD_ADMINS, DIRECTORY1_ID, DIRECTORY1_NAME), (Object)new GroupData(null, CROWD_TESTERS, DIRECTORY1_ID, DIRECTORY1_NAME), (Object)new GroupData(null, CROWD_USERS, DIRECTORY1_ID, DIRECTORY1_NAME), (Object)new GroupData(null, ANIMALS, DIRECTORY2_ID, DIRECTORY2_NAME), (Object)new GroupData(null, BIRDS, DIRECTORY2_ID, DIRECTORY2_NAME), (Object)new GroupData(null, CATS, DIRECTORY2_ID, DIRECTORY2_NAME), (Object)new GroupData(null, DOGS, DIRECTORY2_ID, DIRECTORY2_NAME));
    }

    public void testListGroupsWithParams() throws Exception {
        Pair<Integer, JSONObject> restResponse = this.callRestEndpoint(Method.GET, "/groups", (Map<String, String>)ImmutableMap.of((Object)"prefix", (Object)"cr", (Object)"limit", (Object)"5", (Object)"start", (Object)"0"), null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)200, (int)((Integer)restResponse.getLeft()));
        JSONObject response = (JSONObject)restResponse.getRight();
        UserPermissionAdminResourceTest.assertTrue((boolean)response.getBoolean("last-page"));
        UserPermissionAdminResourceTest.assertEquals((int)5, (int)response.getInt("limit"));
        UserPermissionAdminResourceTest.assertEquals((int)3, (int)response.getInt("size"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("start"));
        JSONArray results = response.getJSONArray("results");
        UserPermissionAdminResourceTest.assertEquals((int)3, (int)results.length());
        UserPermissionAdminResourceTest.assertGroup(results.getJSONObject(0), CROWD_ADMINS, DIRECTORY1_ID, DIRECTORY1_NAME);
        UserPermissionAdminResourceTest.assertGroup(results.getJSONObject(1), CROWD_TESTERS, DIRECTORY1_ID, DIRECTORY1_NAME);
        UserPermissionAdminResourceTest.assertGroup(results.getJSONObject(2), CROWD_USERS, DIRECTORY1_ID, DIRECTORY1_NAME);
        restResponse = this.callRestEndpoint(Method.GET, "/groups", (Map<String, String>)ImmutableMap.of((Object)"prefix", (Object)"b", (Object)"limit", (Object)"1", (Object)"start", (Object)"1"), null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)200, (int)((Integer)restResponse.getLeft()));
        response = (JSONObject)restResponse.getRight();
        UserPermissionAdminResourceTest.assertTrue((boolean)response.getBoolean("last-page"));
        UserPermissionAdminResourceTest.assertEquals((int)1, (int)response.getInt("limit"));
        UserPermissionAdminResourceTest.assertEquals((int)1, (int)response.getInt("size"));
        UserPermissionAdminResourceTest.assertEquals((int)1, (int)response.getInt("start"));
        results = response.getJSONArray("results");
        UserPermissionAdminResourceTest.assertEquals((int)1, (int)results.length());
        UserPermissionAdminResourceTest.assertGroup(results.getJSONObject(0), BIRDS, DIRECTORY2_ID, DIRECTORY2_NAME);
    }

    public void testRevokePermissions() throws Exception {
        this.testGrantPermissions();
        Pair<Integer, JSONObject> restResponse = this.callRestEndpoint(Method.POST, "/revoke", null, UserPermissionAdminResourceTest.buildGroup(DOGS, DIRECTORY2_ID), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)204, (int)((Integer)restResponse.getLeft()));
        JSONObject response = (JSONObject)restResponse.getRight();
        UserPermissionAdminResourceTest.assertNull((Object)response);
        restResponse = this.callRestEndpoint(Method.GET, "", (Map<String, String>)ImmutableMap.of((Object)"permission", (Object)UserPermission.SYS_ADMIN.name()), null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)200, (int)((Integer)restResponse.getLeft()));
        response = (JSONObject)restResponse.getRight();
        List<GroupData> expectedGroups = this.expectedGroupsForTestRevokePermissions();
        UserPermissionAdminResourceTest.assertTrue((boolean)response.getBoolean("last-page"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("limit"));
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)response.getInt("size"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("start"));
        JSONArray results = response.getJSONArray("results");
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)results.length());
        UserPermissionAdminResourceTest.assertPermittedGroups(results, this.expectedGroupsForTestRevokePermissions());
        UserPermissionAdminResourceTest.assertPermissionDenied(USER_PERMISSION_DENIED, this.callRestEndpoint(Method.GET, "", (Map<String, String>)ImmutableMap.of((Object)"permission", (Object)UserPermission.SYS_ADMIN.name()), null, (Credentials)new UsernamePasswordCredentials("regularuser", "regularuser")));
    }

    protected List<GroupData> expectedGroupsForTestRevokePermissions() {
        return ImmutableList.of((Object)new GroupData(UserPermission.SYS_ADMIN, CROWD_ADMINS, DIRECTORY1_ID, DIRECTORY1_NAME));
    }

    public void testGrantPermissions() throws Exception {
        this.intendToModifyData();
        this.addUserToGroup("regularuser", DOGS);
        Pair<Integer, JSONObject> restResponse = this.callRestEndpoint(Method.GET, "", null, null, (Credentials)new UsernamePasswordCredentials("regularuser", "regularuser"));
        UserPermissionAdminResourceTest.assertPermissionDenied(USER_PERMISSION_DENIED, restResponse);
        restResponse = this.callRestEndpoint(Method.PUT, "", (Map<String, String>)ImmutableMap.of((Object)"permission", (Object)UserPermission.ADMIN.name()), UserPermissionAdminResourceTest.buildGroups(UserPermissionAdminResourceTest.buildGroup(DOGS, DIRECTORY2_ID)), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        UserPermissionAdminResourceTest.assertEquals((int)204, (int)((Integer)restResponse.getLeft()));
        JSONObject response = (JSONObject)restResponse.getRight();
        UserPermissionAdminResourceTest.assertNull((Object)response);
        restResponse = this.callRestEndpoint(Method.GET, "", null, null, (Credentials)new UsernamePasswordCredentials("regularuser", "regularuser"));
        UserPermissionAdminResourceTest.assertEquals((int)200, (int)((Integer)restResponse.getLeft()));
        response = (JSONObject)restResponse.getRight();
        List<GroupData> expectedGroups = this.expectedGroupsForTestGrantPermissions();
        UserPermissionAdminResourceTest.assertTrue((boolean)response.getBoolean("last-page"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("limit"));
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)response.getInt("size"));
        UserPermissionAdminResourceTest.assertEquals((int)0, (int)response.getInt("start"));
        JSONArray results = response.getJSONArray("results");
        UserPermissionAdminResourceTest.assertPermittedGroups(results, expectedGroups);
    }

    protected List<GroupData> expectedGroupsForTestGrantPermissions() {
        return ImmutableList.of((Object)new GroupData(UserPermission.SYS_ADMIN, CROWD_ADMINS, DIRECTORY1_ID, DIRECTORY1_NAME), (Object)new GroupData(UserPermission.ADMIN, DOGS, DIRECTORY2_ID, DIRECTORY2_NAME));
    }

    private void addUserToGroup(String userName, String groupName) {
        this.intendToModifyData();
        URI groupMembershipUri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).queryParam("groupname", new Object[]{"{groupname}"}).build(new Object[]{userName, groupName});
        WebResource groupMembershipWebResource = this.getWebResource("crowd", "qybhDMZh", groupMembershipUri);
        URI uri = this.getBaseUriBuilder().path("user").path("group").path("direct").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{userName});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        GroupEntity groupEntity = GroupEntity.newMinimalGroupEntity((String)groupName, (String)"crowd", (URI)URI.create("random"));
        webResource.entity((Object)groupEntity, MT).post();
        GroupEntity newGroupEntity = (GroupEntity)groupMembershipWebResource.get(GroupEntity.class);
        UserPermissionAdminResourceTest.assertEquals((String)groupName, (String)newGroupEntity.getName());
    }

    private static void assertGroup(JSONObject actual, String groupName, Long directoryId, String directoryName) throws JSONException {
        Assert.assertThat(UserPermissionAdminResourceTest.getKeysAsList(actual), (Matcher)Matchers.hasItems((Object[])new String[]{"directory-id", "directory-name", "group-name"}));
        UserPermissionAdminResourceTest.assertEquals((String)directoryName, (String)actual.getString("directory-name"));
        UserPermissionAdminResourceTest.assertEquals((Object)directoryId, (Object)actual.getLong("directory-id"));
        UserPermissionAdminResourceTest.assertEquals((String)groupName, (String)actual.getString("group-name"));
    }

    private static void assertGroups(JSONArray actual, List<GroupData> expectedGroups) throws JSONException {
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)actual.length());
        int i = 0;
        for (GroupData group : expectedGroups) {
            UserPermissionAdminResourceTest.assertGroup(actual.getJSONObject(i), group.groupName, group.directoryId, group.directoryName);
            ++i;
        }
    }

    private static void assertPermittedGroup(JSONObject actual, UserPermission userPermission, String groupName, Long directoryId, String directoryName) throws JSONException {
        Assert.assertThat(UserPermissionAdminResourceTest.getKeysAsList(actual), (Matcher)Matchers.hasItems((Object[])new String[]{"directory-id", "directory-name", "group-name", "permission"}));
        UserPermissionAdminResourceTest.assertEquals((String)directoryName, (String)actual.getString("directory-name"));
        UserPermissionAdminResourceTest.assertEquals((Object)directoryId, (Object)actual.getLong("directory-id"));
        UserPermissionAdminResourceTest.assertEquals((String)groupName, (String)actual.getString("group-name"));
        UserPermissionAdminResourceTest.assertEquals((String)userPermission.name(), (String)actual.getString("permission"));
    }

    private static void assertPermittedGroups(JSONArray actual, List<GroupData> expectedGroups) throws JSONException {
        UserPermissionAdminResourceTest.assertEquals((int)expectedGroups.size(), (int)actual.length());
        int i = 0;
        for (GroupData group : expectedGroups) {
            UserPermissionAdminResourceTest.assertPermittedGroup(actual.getJSONObject(i), group.userPermission, group.groupName, group.directoryId, group.directoryName);
            ++i;
        }
    }

    private static void assertPermissionDenied(String expectedMessage, Pair<Integer, JSONObject> restResponse) throws JSONException {
        UserPermissionAdminResourceTest.assertEquals((int)401, (int)((Integer)restResponse.getLeft()));
        Assert.assertThat(UserPermissionAdminResourceTest.getKeysAsList((JSONObject)restResponse.getRight()), (Matcher)Matchers.hasItems((Object[])new String[]{"message", "reason"}));
        UserPermissionAdminResourceTest.assertEquals((String)expectedMessage, (String)((JSONObject)restResponse.getRight()).getString("message"));
        UserPermissionAdminResourceTest.assertEquals((String)"PERMISSION_DENIED", (String)((JSONObject)restResponse.getRight()).getString("reason"));
    }

    private static List<String> getKeysAsList(JSONObject object) {
        return ImmutableList.copyOf((Iterator)object.keys());
    }

    private static JSONArray buildGroups(JSONObject ... groups) throws JSONException {
        return new JSONArray((Object)groups);
    }

    private static JSONObject buildGroup(String groupName, Long directoryId) throws JSONException {
        return new JSONObject("{'group-name':'" + groupName + "','directory-id':" + directoryId + "}");
    }

    private Pair<Integer, JSONObject> callRestEndpoint(Method method, String endpointSuffix, Map<String, String> paramMap, Object data, Credentials creds) throws IOException, URISyntaxException, JSONException {
        URI url;
        StringEntity requestEntity = data == null ? null : new StringEntity(data.toString(), ContentType.create((String)"application/json"));
        String endpoint = this.getBaseUriBuilder("permissions").build(new Object[0]).toString() + "/admin" + endpointSuffix;
        CloseableHttpClient client = HttpClients.createDefault();
        URI base = this.getServerUriBuilder().build(new Object[0]);
        HttpCacheContext context = HttpCacheContext.create();
        if (creds != null) {
            HttpHost host = new HttpHost(base.getHost(), base.getPort());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host), creds);
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(host, (AuthScheme)basicAuth);
            context.setAuthCache((AuthCache)authCache);
        }
        if (paramMap != null) {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            Iterable nameValuePairs = Iterables.transform(paramMap.entrySet(), (Function)new Function<Map.Entry<String, String>, NameValuePair>(){

                public NameValuePair apply(Map.Entry<String, String> input) {
                    return new BasicNameValuePair(input.getKey(), input.getValue());
                }
            });
            uriBuilder.addParameters((List)ImmutableList.copyOf((Iterable)nameValuePairs));
            url = uriBuilder.build();
        } else {
            url = new URI(endpoint);
        }
        HttpUriRequest httpMethod = method.build(url, (HttpEntity)requestEntity);
        if (requestEntity != null) {
            httpMethod.addHeader("Content-Type", "application/json");
        }
        httpMethod.addHeader("Accept", "application/json");
        HttpResponse r = client.execute(httpMethod, (HttpContext)context);
        HttpEntity entity = r.getEntity();
        if (entity != null) {
            Assert.assertThat((Object)r.getFirstHeader("Content-Type").getValue(), (Matcher)Matchers.containsString((String)"application/json"));
        }
        return Pair.of((Object)r.getStatusLine().getStatusCode(), (Object)(entity == null ? null : new JSONObject(EntityUtils.toString((HttpEntity)entity))));
    }

    protected class GroupData {
        final UserPermission userPermission;
        final String groupName;
        final Long directoryId;
        final String directoryName;

        public GroupData(UserPermission userPermission, String groupName, Long directoryId, String directoryName) {
            this.userPermission = userPermission;
            this.groupName = groupName;
            this.directoryId = directoryId;
            this.directoryName = directoryName;
        }
    }

    static enum Method {
        GET{

            @Override
            public HttpUriRequest build(URI endpoint, HttpEntity entity) {
                return new HttpGet(endpoint);
            }
        }
        ,
        PUT{

            @Override
            public HttpUriRequest build(URI endpoint, HttpEntity entity) {
                HttpPut putMethod = new HttpPut(endpoint);
                if (entity != null) {
                    putMethod.setEntity(entity);
                }
                return putMethod;
            }
        }
        ,
        POST{

            @Override
            public HttpUriRequest build(URI endpoint, HttpEntity entity) {
                HttpPost putMethod = new HttpPost(endpoint);
                if (entity != null) {
                    putMethod.setEntity(entity);
                }
                return putMethod;
            }
        };


        public abstract HttpUriRequest build(URI var1, HttpEntity var2);
    }
}

