/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.plugin.rest.entity.AuthenticationContextEntity;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.SessionEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntityList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;

public class TokenResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String USERNAME = "eeeep";
    private static final String PASSWORD = "eep";
    private static final String BAD_PASSWORD = "bad_password";
    private static final ValidationFactorEntity restFactor1 = new ValidationFactorEntity("remote_address", "127.0.0.1");
    private static final ValidationFactorEntity restFactor2 = new ValidationFactorEntity("remote_host", "blah");
    private static final ValidationFactorEntityList restFactors = new ValidationFactorEntityList((List)ImmutableList.of((Object)restFactor1, (Object)restFactor2));

    public TokenResourceTest(String name) {
        super(name);
    }

    public TokenResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deleteSessionsFor(USERNAME);
    }

    private void deleteSessionsFor(String username) {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").queryParam("username", username);
        webResource.delete();
    }

    public void testUserAuthentication() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        SessionEntity session = (SessionEntity)response.getEntity(SessionEntity.class);
        TokenResourceTest.assertNotNull((String)"Session should contain a link", (Object)session.getLink());
        TokenResourceTest.assertNotNull((String)"Session should contain a token key", (Object)session.getToken());
        TokenResourceTest.assertNotNull((String)"Session creation date should be returned", (Object)session.getCreatedDate());
        TokenResourceTest.assertNotNull((String)"Session expiry date should be returned", (Object)session.getExpiryDate());
        TokenResourceTest.assertUserEntityIsMinimal(session);
    }

    public void testUserAuthentication_WithoutPasswordValidation() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").queryParam("validate-password", "false");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, null, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        SessionEntity session = (SessionEntity)response.getEntity(SessionEntity.class);
        TokenResourceTest.assertNotNull((String)"Session should contain a link", (Object)session.getLink());
        TokenResourceTest.assertNotNull((String)"Session should contain a token key", (Object)session.getToken());
        TokenResourceTest.assertNotNull((String)"Session creation date should be returned", (Object)session.getCreatedDate());
        TokenResourceTest.assertNotNull((String)"Session expiry date should be returned", (Object)session.getExpiryDate());
        TokenResourceTest.assertUserEntityIsMinimal(session);
    }

    public void testInvalidUserAuthentication() {
        block2: {
            WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
            AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, BAD_PASSWORD, restFactors);
            try {
                webResource.entity((Object)authContext, MT).post(SessionEntity.class);
                TokenResourceTest.fail((String)"Should have failed authentication and thrown a UniformInterfaceException.");
            }
            catch (UniformInterfaceException e) {
                if (e.getResponse().getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) break block2;
                TokenResourceTest.fail((String)("Should have returned a " + Response.Status.BAD_REQUEST.getStatusCode() + " status code."));
            }
        }
    }

    public void testGetUserFromToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        SessionEntity session = (SessionEntity)webResource.get(SessionEntity.class);
        TokenResourceTest.assertNotNull((String)"Session creation date should be returned", (Object)session.getCreatedDate());
        TokenResourceTest.assertNotNull((String)"Session expiry date should be returned", (Object)session.getExpiryDate());
        TokenResourceTest.assertUserEntityIsExpanded(session);
    }

    public void testValidateToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        ClientResponse validationResponse = (ClientResponse)webResource.entity((Object)restFactors, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)200, (int)validationResponse.getStatus());
        SessionEntity session = (SessionEntity)validationResponse.getEntity(SessionEntity.class);
        TokenResourceTest.assertNotNull((String)"Session creation date should be returned", (Object)session.getCreatedDate());
        TokenResourceTest.assertNotNull((String)"Session expiry date should be returned", (Object)session.getExpiryDate());
        TokenResourceTest.assertUserEntityIsMinimal(session);
    }

    public void testShortLivedTokenExpiresImmediately() {
        ClientResponse response = this.getShortLivedToken();
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        WebResource validationWebResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        ClientResponse validationResponse = (ClientResponse)validationWebResource.entity((Object)restFactors, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((String)"Token should have expired", (int)404, (int)validationResponse.getStatus());
    }

    private ClientResponse getShortLivedToken() {
        WebResource authenticationWebResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").queryParam("duration", "0");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)authenticationWebResource.entity((Object)authContext, MT).post(ClientResponse.class);
        return response;
    }

    @Test(timeout=5000L)
    public void testMultipleShortLivedSessionsShouldNotDeadlock() throws Exception {
        this.getShortLivedToken();
        this.getShortLivedToken();
    }

    public void testMultipleTokensWithDifferentPrivilegesDoNotInterfereWithEachOther() {
        ValidationFactorEntity privilegeFactor = new ValidationFactorEntity("PRIVILEGE_LEVEL", "WebSudo");
        ValidationFactorEntityList validationFactors1 = new ValidationFactorEntityList((List)ImmutableList.of((Object)restFactor1, (Object)restFactor2));
        ValidationFactorEntityList validationFactors2 = new ValidationFactorEntityList((List)ImmutableList.of((Object)restFactor1, (Object)restFactor2, (Object)privilegeFactor));
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext1 = new AuthenticationContextEntity(USERNAME, PASSWORD, validationFactors1);
        ClientResponse createSessionResponse1 = (ClientResponse)webResource.entity((Object)authContext1, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)createSessionResponse1.getStatus());
        AuthenticationContextEntity authContext2 = new AuthenticationContextEntity(USERNAME, PASSWORD, validationFactors2);
        ClientResponse createSessionResponse2 = (ClientResponse)webResource.entity((Object)authContext2, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)createSessionResponse2.getStatus());
        Assert.assertNotEquals((Object)createSessionResponse1.getLocation(), (Object)createSessionResponse2.getLocation());
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse1.getLocation());
        webResource.entity((Object)validationFactors1, MT).post();
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse2.getLocation());
        webResource.entity((Object)validationFactors2, MT).post();
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse1.getLocation());
        ClientResponse validationResponse1 = (ClientResponse)webResource.entity((Object)validationFactors2, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)400, (int)validationResponse1.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse2.getLocation());
        ClientResponse validationResponse2 = (ClientResponse)webResource.entity((Object)validationFactors1, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)400, (int)validationResponse2.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse2.getLocation());
        ClientResponse deleteResponse1 = (ClientResponse)webResource.delete(ClientResponse.class);
        TokenResourceTest.assertEquals((int)204, (int)deleteResponse1.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse2.getLocation());
        validationResponse2 = (ClientResponse)webResource.entity((Object)validationFactors2, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)404, (int)validationResponse2.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", createSessionResponse1.getLocation());
        webResource.entity((Object)validationFactors1, MT).post();
    }

    public void testCreatedTokenUsesDirectoryCaseForUsername() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        String differentCaseUsername = USERNAME.toUpperCase();
        Assert.assertNotEquals((Object)USERNAME, (Object)differentCaseUsername);
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(differentCaseUsername, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        SessionEntity session = (SessionEntity)webResource.entity((Object)restFactors, MT).post(SessionEntity.class);
        TokenResourceTest.assertEquals((String)"The validated token username is in the directory case", (String)USERNAME, (String)session.getUser().getName());
    }

    public void testValidateToken_InvalidToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").path("invalidtoken");
        ClientResponse response = (ClientResponse)webResource.entity((Object)restFactors, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testValidateToken_InvalidValidationFactors() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        ValidationFactorEntity wrongFac = new ValidationFactorEntity("remote_address", "wrongFactor");
        ValidationFactorEntityList wrongFactors = new ValidationFactorEntityList(Arrays.asList(wrongFac));
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        response = (ClientResponse)webResource.entity((Object)wrongFactors, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)400, (int)response.getStatus());
    }

    public void testInvalidateToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        URI uri = response.getLocation();
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        response = (ClientResponse)webResource.delete(ClientResponse.class);
        TokenResourceTest.assertEquals((int)204, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        response = (ClientResponse)webResource.entity((Object)restFactors, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testTokenIsDeletedWhenUserIsRemoved() {
        this.intendToModifyData();
        String token = this.createSession(USERNAME, PASSWORD, restFactors);
        this.assertActiveSession(token, restFactors);
        this.deleteUser(USERNAME);
        this.assertInactiveSession(token, restFactors);
    }

    public void testTokenIsDeletedWhenUserChangesPassword() {
        this.intendToModifyData();
        String token = this.createSession(USERNAME, PASSWORD, restFactors);
        this.assertActiveSession(token, restFactors);
        URI uri = this.getBaseUriBuilder().path("user").path("password").queryParam("username", new Object[]{USERNAME}).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        webResource.put((Object)new PasswordEntity("pass2", null));
        this.assertInactiveSession(token, restFactors);
    }

    private void deleteUser(String username) {
        URI uri = this.getBaseUriBuilder().path("user").queryParam("username", new Object[]{"{username}"}).build(new Object[]{username});
        WebResource userResource = this.getWebResource("crowd", "qybhDMZh", uri);
        ClientResponse userDeletionResponse = (ClientResponse)userResource.delete(ClientResponse.class);
        TokenResourceTest.assertEquals((int)204, (int)userDeletionResponse.getStatus());
    }

    public void testGetUserFromTokenEnforcesApplicationAuthenticationChecks() {
        WebResource appAllowed = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        WebResource appNotAllowed = this.getRootWebResource("no-user-application", "password").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(USERNAME, PASSWORD, restFactors);
        ClientResponse r = (ClientResponse)appNotAllowed.queryParam("validate-password", "true").entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((String)"User cannot log into appNotAllowed", (int)Response.Status.FORBIDDEN.getStatusCode(), (int)r.getStatus());
        SessionEntity session = (SessionEntity)appAllowed.queryParam("validate-password", "true").entity((Object)authContext, MT).post(SessionEntity.class);
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        String token = session.getToken();
        SessionEntity checkedSession = (SessionEntity)appAllowed.path(token).get(SessionEntity.class);
        TokenResourceTest.assertEquals((String)"The token is accepted for appAllowed", (String)USERNAME, (String)checkedSession.getUser().getName());
        ClientResponse r2 = (ClientResponse)appNotAllowed.path(token).get(ClientResponse.class);
        TokenResourceTest.assertEquals((String)"The token fails against appNotAllowed", (int)Response.Status.FORBIDDEN.getStatusCode(), (int)r2.getStatus());
    }

    private String createSession(String username, String password, ValidationFactorEntityList factors) {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(username, password, factors);
        SessionEntity response = (SessionEntity)webResource.entity((Object)authContext, MT).post(SessionEntity.class);
        return response.getToken();
    }

    private int sessionStatus(String token, ValidationFactorEntityList factors) {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").path(token);
        return ((ClientResponse)webResource.entity((Object)factors, MT).post(ClientResponse.class)).getStatus();
    }

    private void assertActiveSession(String token, ValidationFactorEntityList factors) {
        TokenResourceTest.assertEquals((int)200, (int)this.sessionStatus(token, factors));
    }

    private void assertInactiveSession(String token, ValidationFactorEntityList factors) {
        TokenResourceTest.assertEquals((int)404, (int)this.sessionStatus(token, factors));
    }

    private Map<String, ValidationFactorEntityList> createUserSessions(int count) {
        HashMap<String, ValidationFactorEntityList> adminSessions = new HashMap<String, ValidationFactorEntityList>();
        for (int i = 0; i < count; ++i) {
            ValidationFactorEntity factor = new ValidationFactorEntity("remote_address", "127.0.0." + i);
            ValidationFactorEntityList restFactors = new ValidationFactorEntityList((List)ImmutableList.of((Object)factor));
            String token = this.createSession(USERNAME, PASSWORD, restFactors);
            adminSessions.put(token, restFactors);
        }
        TokenResourceTest.assertEquals((int)count, (int)adminSessions.size());
        return adminSessions;
    }

    public void testAllSessionsForUserAreInvalidatedByDeleteWithUsernameSpecified() {
        Map<String, ValidationFactorEntityList> adminSessions = this.createUserSessions(5);
        String otherAdminSession = this.createSession("secondadmin", "secondadmin", restFactors);
        for (Map.Entry<String, ValidationFactorEntityList> e : adminSessions.entrySet()) {
            this.assertActiveSession(e.getKey(), e.getValue());
        }
        this.assertActiveSession(otherAdminSession, restFactors);
        WebResource sessionWebResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        WebResource webResource = sessionWebResource.queryParam("username", USERNAME);
        TokenResourceTest.assertEquals((int)204, (int)((ClientResponse)webResource.delete(ClientResponse.class)).getStatus());
        for (Map.Entry<String, ValidationFactorEntityList> e : adminSessions.entrySet()) {
            this.assertInactiveSession(e.getKey(), e.getValue());
        }
        this.assertActiveSession(otherAdminSession, restFactors);
    }

    public void testSpecifiedUserSessionIsExcludedFromDeletionByUsername() {
        Map<String, ValidationFactorEntityList> sessions = this.createUserSessions(5);
        for (Map.Entry<String, ValidationFactorEntityList> e : sessions.entrySet()) {
            this.assertActiveSession(e.getKey(), e.getValue());
        }
        String tokenToExclude = (String)Iterables.getLast(sessions.keySet());
        WebResource sessionWebResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        WebResource webResource = sessionWebResource.queryParam("username", USERNAME).queryParam("exclude", tokenToExclude);
        TokenResourceTest.assertEquals((int)204, (int)((ClientResponse)webResource.delete(ClientResponse.class)).getStatus());
        HashMap<String, Integer> expectedStatuses = new HashMap<String, Integer>();
        for (Map.Entry<String, ValidationFactorEntityList> e : sessions.entrySet()) {
            expectedStatuses.put(e.getKey(), 404);
        }
        expectedStatuses.put(tokenToExclude, 200);
        HashMap<String, Integer> statuses = new HashMap<String, Integer>();
        for (Map.Entry<String, ValidationFactorEntityList> e : sessions.entrySet()) {
            statuses.put(e.getKey(), this.sessionStatus(e.getKey(), e.getValue()));
        }
        TokenResourceTest.assertEquals(expectedStatuses, statuses);
    }

    public void testStatusNotFoundWhenDeletingTokensForNonexistentUser() {
        WebResource sessionWebResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        WebResource webResource = sessionWebResource.queryParam("username", "no-such-user");
        TokenResourceTest.assertEquals((int)404, (int)((ClientResponse)webResource.delete(ClientResponse.class)).getStatus());
    }

    private static void assertUserEntityIsMinimal(SessionEntity session) {
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        TokenResourceTest.assertNull((String)"User entity should not contain a first name", (Object)session.getUser().getFirstName());
        TokenResourceTest.assertNull((String)"User entity should not contain a last name", (Object)session.getUser().getLastName());
        TokenResourceTest.assertNull((String)"User entity should not contain a display name", (Object)session.getUser().getDisplayName());
        TokenResourceTest.assertNull((String)"User entity should not contain an email ", (Object)session.getUser().getEmail());
        TokenResourceTest.assertNull((String)"User entity should not contain a password", (Object)session.getUser().getPassword());
    }

    private static void assertUserEntityIsExpanded(SessionEntity session) {
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        TokenResourceTest.assertEquals((String)"Zeee Pop!", (String)session.getUser().getDisplayName());
        TokenResourceTest.assertEquals((String)"Zeee", (String)session.getUser().getFirstName());
        TokenResourceTest.assertEquals((String)"Pop!", (String)session.getUser().getLastName());
        TokenResourceTest.assertEquals((String)"doflynn@atlassian.com", (String)session.getUser().getEmail());
        TokenResourceTest.assertTrue((String)"User should be active", (boolean)session.getUser().isActive());
        TokenResourceTest.assertNull((String)"Password should not be visible", (Object)session.getUser().getPassword().getValue());
    }

    SessionEntity createSessionAsApplication(String appName, String appPass, String username, String password) {
        WebResource webResource = this.getRootWebResource(appName, appPass).path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity(username, password, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        return (SessionEntity)response.getEntity(SessionEntity.class);
    }

    SessionEntity createSessionAsUnaliasedApplication(String username, String password) {
        return this.createSessionAsApplication("crowd", "qybhDMZh", username, password);
    }

    SessionEntity createSessionAsAliasedApplication(String username, String password) {
        return this.createSessionAsApplication("aliases", "aliases", username, password);
    }

    public void testSessionCreatedWithUnaliasedApplicationShowsAliasedNameWhenRetrievedWithAliasingApplication() {
        SessionEntity session = this.createSessionAsUnaliasedApplication(USERNAME, PASSWORD);
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        WebResource wr2 = this.getWebResource("aliases", "aliases", session.getLink().getHref());
        SessionEntity aliasedSession = (SessionEntity)wr2.get(SessionEntity.class);
        TokenResourceTest.assertEquals((String)"alias2", (String)aliasedSession.getUser().getName());
    }

    public void testSessionCreatedWithUnaliasedApplicationShowsAliasedNameWhenValidatedWithAliasingApplication() {
        SessionEntity session = this.createSessionAsUnaliasedApplication(USERNAME, PASSWORD);
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        WebResource webResource = this.getWebResource("aliases", "aliases", session.getLink().getHref());
        ClientResponse validationResponse = (ClientResponse)webResource.entity((Object)restFactors, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)200, (int)validationResponse.getStatus());
        TokenResourceTest.assertEquals((String)"alias2", (String)((SessionEntity)validationResponse.getEntity(SessionEntity.class)).getUser().getName());
    }

    public void testSessionCreatedThroughAliasedApplicationShowsOriginalNameWhenRetrievedWithNonAliasingApplication() {
        SessionEntity session = this.createSessionAsAliasedApplication("alias2", PASSWORD);
        TokenResourceTest.assertEquals((String)"alias2", (String)session.getUser().getName());
        WebResource wr2 = this.getWebResource("crowd", "qybhDMZh", session.getLink().getHref());
        SessionEntity aliasedSession = (SessionEntity)wr2.get(SessionEntity.class);
        TokenResourceTest.assertEquals((String)USERNAME, (String)aliasedSession.getUser().getName());
    }

    public void testSessionCreatedWithDifferentCaseReturnsCorrectCaseForUsername() {
        TokenResourceTest.assertEquals((String)USERNAME, (String)this.createSessionAsUnaliasedApplication("EeeeP", PASSWORD).getUser().getName());
    }

    public void testSessionCreatedThroughAliasWithDifferentCaseReturnsCorrectCase() {
        TokenResourceTest.assertEquals((String)"alias2", (String)this.createSessionAsAliasedApplication("AliaS2", PASSWORD).getUser().getName());
    }

    public void testSessionCannotBeCreatedWithAliasThroughUnaliasedApplication() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("alias2", PASSWORD, restFactors);
        ClientResponse response = (ClientResponse)webResource.entity((Object)authContext, MT).post(ClientResponse.class);
        TokenResourceTest.assertEquals((int)400, (int)response.getStatus());
    }

    public void testAliasedApplicationAlsoAcceptsUnaliasedUsername() {
        TokenResourceTest.assertEquals((String)"alias2", (String)this.createSessionAsAliasedApplication(USERNAME, PASSWORD).getUser().getName());
    }

    protected void setAliasForUsername(String alias) {
        URI uri = this.getBaseUriBuilder("appmanagement", "1").path("aliases").path("884737").path("alias").queryParam("user", new Object[]{USERNAME}).build(new Object[0]);
        WebResource aliasWebResource = this.getWebResource("admin", "admin", uri);
        aliasWebResource.put((Object)alias);
    }

    public void testAliasChangesAreReflectedInSessionUsername() {
        this.intendToModifyData();
        SessionEntity session = this.createSessionAsUnaliasedApplication(USERNAME, PASSWORD);
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        WebResource webResource = this.getWebResource("aliases", "aliases", session.getLink().getHref());
        this.setAliasForUsername("new-alias");
        TokenResourceTest.assertEquals((String)"new-alias", (String)((SessionEntity)webResource.get(SessionEntity.class)).getUser().getName());
        this.setAliasForUsername("new-alias-2");
        TokenResourceTest.assertEquals((String)"new-alias-2", (String)((SessionEntity)webResource.get(SessionEntity.class)).getUser().getName());
    }

    public void testSessionForAliasedApplicationIncludesUnaliasedUsernameAsAnExtraField() {
        SessionEntity session = this.createSessionAsUnaliasedApplication(USERNAME, PASSWORD);
        TokenResourceTest.assertEquals((String)USERNAME, (String)session.getUser().getName());
        TokenResourceTest.assertNull((Object)session.getUnaliasedUsername());
        WebResource wr2 = this.getWebResource("aliases", "aliases", session.getLink().getHref());
        SessionEntity aliasedSession = (SessionEntity)wr2.get(SessionEntity.class);
        TokenResourceTest.assertEquals((String)"alias2", (String)aliasedSession.getUser().getName());
        TokenResourceTest.assertEquals((String)USERNAME, (String)aliasedSession.getUnaliasedUsername());
    }
}

