/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.NamedEntity;
import com.atlassian.crowd.plugin.rest.entity.NullRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.SearchRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.util.SearchRestrictionEntityTranslator;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyIterable;
import org.junit.Assert;

public class SearchResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String SEARCH_RESOURCE = "search";
    private static final String START_INDEX_PARAM = "start-index";
    private static final String MAX_RESULT_PARAM = "max-results";
    private static final String ENTITY_TYPE_PARAM = "entity-type";
    private static final String USER_ENTITY_TYPE = "user";
    private static final String GROUP_ENTITY_TYPE = "group";
    private static final String EXPAND_PARAM = "expand";
    private static final String USER_PARAM_VALUE = "user";
    private static final String GROUP_PARAM_VALUE = "group";
    private static final String ATTRIBUTES_PARAM_VALUE = "attributes";
    private static final String RESTRICTION_PARAM = "restriction";
    private static final String USERNAME1 = "admin";
    private static final String USERNAME2 = "eeeep";
    private static final String USERNAME3 = "penny";
    private static final String USERNAME4 = "regularuser";
    private static final String USERNAME5 = "secondadmin";
    private static final String USERNAME6 = "dir1user";
    private static final String GROUP1 = "animals";
    private static final String GROUP2 = "badgers";
    private static final String GROUP3 = "birds";
    private static final String GROUP4 = "cats";
    private static final String GROUP5 = "crowd-administrators";
    private static final String GROUP6 = "crowd-testers";
    private static final String GROUP7 = "crowd-users";
    private static final String GROUP8 = "dogs";
    private static final String EMAIL1 = "bob@example.net";
    private static final String NON_EXISTENT_EMAIL = "nosuchemail@nosuchemail.com";
    private static final int TOTAL_NUM_USERS;
    private static final Set<String> ALL_USERNAMES;
    private static final String ALIAS_APPLICATION_NAME = "aliases";
    private static final String ALIAS_APPLICATION_PASSWORD = "aliases";

    public SearchResourceTest(String name) {
        super(name);
    }

    public SearchResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetUnknownEntityType() throws Exception {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"UNKNOWN"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        try {
            webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
            SearchResourceTest.fail((String)(expectedStatus + " expected"));
        }
        catch (UniformInterfaceException e) {
            ErrorEntity errorEntity = (ErrorEntity)e.getResponse().getEntity(ErrorEntity.class);
            SearchResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.ILLEGAL_ARGUMENT, (Object)errorEntity.getReason());
            SearchResourceTest.assertEquals((int)expectedStatus.getStatusCode(), (int)e.getResponse().getStatus());
        }
    }

    public void testGetUserNames() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
        Set<String> userNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertEquals(ALL_USERNAMES, userNames);
    }

    public void testGetUserNames_MaxResult() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(MAX_RESULT_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
        Set<String> userNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertEquals((int)3, (int)userNames.size());
    }

    public void testGetUserNames_StartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(START_INDEX_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
        Set<String> userNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertEquals((int)(TOTAL_NUM_USERS - 3), (int)userNames.size());
    }

    public void testGetUserNames_Aliases() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("aliases", "aliases", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"alias")), MT).post(UserEntityList.class);
        Set<String> userNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"alias1", "alias2", "alias3"}), userNames);
    }

    public void testGetUserNames_AliasesIgnoreUsernameWhenAliasExists() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("aliases", "aliases", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)USERNAME1)), MT).post(UserEntityList.class);
        Set<String> userNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{USERNAME5}), userNames);
    }

    public void testGetUserNames_AliasesAll() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("aliases", "aliases", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"a")), MT).post(UserEntityList.class);
        Set<String> userNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"alias1", "alias2", "alias3", USERNAME5}), userNames);
    }

    public void testGetUserNames_NegativeStartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(START_INDEX_PARAM, new Object[]{"-1"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        try {
            webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
            SearchResourceTest.fail((String)"Should have returned a Bad Request Error (400) status.");
        }
        catch (UniformInterfaceException e) {
            ClientResponse response = e.getResponse();
            SearchResourceTest.assertEquals((String)"Should have returned a Bad Request Error (400) status.", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        }
    }

    public void testGetUserNames_EmailRestriction() {
        PropertyRestriction emailRestriction = Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)EMAIL1);
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)emailRestriction);
        UserEntityList users = (UserEntityList)webResource.entity((Object)restriction, MT).post(UserEntityList.class);
        Set<String> usernames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        HashSet expectedUsernames = Sets.newHashSet((Object[])new String[]{USERNAME1, USERNAME4});
        SearchResourceTest.assertEquals((Object)expectedUsernames, usernames);
        PropertyRestriction nonExistentEmailRestriction = Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)NON_EXISTENT_EMAIL);
        SearchRestrictionEntity restRestriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)nonExistentEmailRestriction);
        users = (UserEntityList)webResource.entity((Object)restRestriction, MT).post(UserEntityList.class);
        usernames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        SearchResourceTest.assertTrue((boolean)usernames.isEmpty());
    }

    public void testGetUsers() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
        SearchResourceTest.assertEquals((int)TOTAL_NUM_USERS, (int)users.size());
    }

    public void testGetUsers_UserRestriction() {
        PropertyRestriction usernameRestriction = Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)USERNAME2);
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)usernameRestriction);
        UserEntityList users = (UserEntityList)webResource.entity((Object)restriction, MT).post(UserEntityList.class);
        SearchResourceTest.assertEquals((int)1, (int)users.size());
        SearchResourceTest.assertEquals((String)USERNAME2, (String)users.get(0).getName());
        SearchResourceTest.assertEquals((String)"doflynn@atlassian.com", (String)users.get(0).getEmail());
    }

    public void testGetUsersRestrictionOnUnusedCustomAttributeReturnsNoUsers() {
        PropertyImpl customAttribute = new PropertyImpl("a-custom-property", String.class);
        PropertyRestriction propRestriction = Restriction.on((Property)customAttribute).exactlyMatching((Object)"custom-value");
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)propRestriction);
        UserEntityList users = (UserEntityList)webResource.entity((Object)restriction, MT).post(UserEntityList.class);
        Assert.assertThat((Object)users, (Matcher)IsEmptyIterable.emptyIterable());
    }

    public void testGetUsersRestrictionOnCustomAttributeReturnsUser() {
        this.intendToModifyData();
        URI userUri = this.getBaseUriBuilder().path("user").path("attribute").queryParam("username", new Object[]{USERNAME4}).build(new Object[0]);
        MultiValuedAttributeEntity attrib1 = new MultiValuedAttributeEntity("a-custom-property", (Collection)ImmutableSet.of((Object)"custom-value"), null);
        MultiValuedAttributeEntityList attributes = new MultiValuedAttributeEntityList(Arrays.asList(attrib1), null);
        this.getWebResource(APPLICATION_NAME, "qybhDMZh", userUri).entity((Object)attributes, MT).post();
        PropertyImpl customAttribute = new PropertyImpl("a-custom-property", String.class);
        PropertyRestriction propRestriction = Restriction.on((Property)customAttribute).exactlyMatching((Object)"custom-value");
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)propRestriction);
        UserEntityList users = (UserEntityList)webResource.entity((Object)restriction, MT).post(UserEntityList.class);
        SearchResourceTest.assertEquals((Object)ImmutableSet.of((Object)USERNAME4), SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users));
    }

    public void testGetUsersCqlRestrictionOnCustomAttributeReturnsUser() {
        this.intendToModifyData();
        URI userUri = this.getBaseUriBuilder().path("user").path("attribute").queryParam("username", new Object[]{USERNAME4}).build(new Object[0]);
        String customAttrName = "a-custom-property";
        String customAttrValue = "custom-value";
        MultiValuedAttributeEntity attrib = new MultiValuedAttributeEntity("a-custom-property", (Collection)ImmutableSet.of((Object)"custom-value"), null);
        MultiValuedAttributeEntityList attributes = new MultiValuedAttributeEntityList(Collections.singletonList(attrib), null);
        this.getWebResource(APPLICATION_NAME, "qybhDMZh", userUri).entity((Object)attributes, MT).post();
        String cql = "a-custom-property=custom-value";
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).queryParam(RESTRICTION_PARAM, new Object[]{"a-custom-property=custom-value"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.type(MT).get(UserEntityList.class);
        Assert.assertThat(SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users), (Matcher)Matchers.contains((Object[])new String[]{USERNAME4}));
    }

    public void testGetUsersCqlRestrictionOnCustomAttributeWithNullMatchReturnsUsersWithoutTheCustomAttribute() {
        this.intendToModifyData();
        URI userUri = this.getBaseUriBuilder().path("user").path("attribute").queryParam("username", new Object[]{USERNAME4}).build(new Object[0]);
        String customAttrName = "a-custom-property";
        String customAttrValue = "custom-value";
        MultiValuedAttributeEntity attrib = new MultiValuedAttributeEntity("a-custom-property", (Collection)ImmutableSet.of((Object)"custom-value"), null);
        MultiValuedAttributeEntityList attributes = new MultiValuedAttributeEntityList(Collections.singletonList(attrib), null);
        this.getWebResource(APPLICATION_NAME, "qybhDMZh", userUri).entity((Object)attributes, MT).post();
        String cql = "a-custom-property is nUlL";
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).queryParam(RESTRICTION_PARAM, new Object[]{"a-custom-property is nUlL"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.type(MT).get(UserEntityList.class);
        Set<String> foundUsers = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)users);
        Set<String> expectedUsers = SearchResourceTest.setWithout(SearchResourceTest.getAllUsernames(), USERNAME4);
        SearchResourceTest.assertTrue((String)"We should at least get some users back in this test (else it's not useful)", (expectedUsers.size() > 0 ? 1 : 0) != 0);
        SearchResourceTest.assertEquals((String)"Only users without the custom attribute set should be returned", expectedUsers, foundUsers);
    }

    private static <T> Set<T> setWithout(Set<T> set, final T toRemove) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(set, (Predicate)new Predicate<T>(){

            public boolean apply(T setItem) {
                return !toRemove.equals(setItem);
            }
        }));
    }

    public void testGetUser_StartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).queryParam(START_INDEX_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(UserEntityList.class);
        SearchResourceTest.assertEquals((int)(TOTAL_NUM_USERS - 3), (int)users.size());
    }

    public void testGetGroupNames() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(GroupEntityList.class);
        Set<String> groupNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups);
        SearchResourceTest.assertEquals(this.getAllGroupnames(), groupNames);
    }

    protected Set<String> getAllGroupnames() {
        return ImmutableSet.of((Object)GROUP1, (Object)GROUP2, (Object)GROUP3, (Object)GROUP4, (Object)GROUP5, (Object)GROUP6, (Object[])new String[]{GROUP7, GROUP8});
    }

    private static Set<String> getAllUsernames() {
        return ImmutableSet.of((Object)USERNAME1, (Object)USERNAME6, (Object)USERNAME2, (Object)USERNAME3, (Object)USERNAME4, (Object)USERNAME5, (Object[])new String[0]);
    }

    public void testGetGroupNames_Restricted() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(MAX_RESULT_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(GroupEntityList.class);
        Set<String> groupNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups);
        SearchResourceTest.assertEquals((int)3, (int)groupNames.size());
    }

    public void testGetGroupNames_StartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(START_INDEX_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(GroupEntityList.class);
        Set<String> groupNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups);
        SearchResourceTest.assertEquals((int)(this.getAllGroupnames().size() - 3), (int)groupNames.size());
    }

    public void testGetGroupNames_ActiveRestriction() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        PropertyRestriction groupActiveRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)groupActiveRestriction);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)restriction, MT).post(GroupEntityList.class);
        Set<String> groupNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups);
        SearchResourceTest.assertEquals(this.getAllGroupnames(), groupNames);
        groupActiveRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)false);
        restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)groupActiveRestriction);
        groups = (GroupEntityList)webResource.entity((Object)restriction, MT).post(GroupEntityList.class);
        groupNames = SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups);
        SearchResourceTest.assertTrue((boolean)groupNames.isEmpty());
    }

    public void testGetGroupsCqlRestrictionOnCustomAttributeReturnsGroup() {
        String customAttrName = "secret-location";
        String customAttrValue = "hollow";
        String cql = "secret-location=hollow";
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(EXPAND_PARAM, new Object[]{"group"}).queryParam(RESTRICTION_PARAM, new Object[]{"secret-location=hollow"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.type(MT).get(GroupEntityList.class);
        Assert.assertThat(SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups), (Matcher)Matchers.contains((Object[])new String[]{GROUP2}));
    }

    public void testGetGroups() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(EXPAND_PARAM, new Object[]{"group"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(GroupEntityList.class);
        SearchResourceTest.assertEquals(SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups), this.getAllGroupnames());
    }

    public void testGetGroupsWithExpandAttributesReturnsGroups() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(EXPAND_PARAM, new Object[]{"group", ATTRIBUTES_PARAM_VALUE}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(GroupEntityList.class);
        SearchResourceTest.assertEquals(SearchResourceTest.getNames((Iterable<? extends NamedEntity>)groups), this.getAllGroupnames());
    }

    public void testGetGroupsWithExpandAttributesCanGetAttributes() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(EXPAND_PARAM, new Object[]{"group", ATTRIBUTES_PARAM_VALUE}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.entity((Object)NullRestrictionEntity.INSTANCE, MT).post(GroupEntityList.class);
        SearchResourceTest.assertEquals((int)((GroupEntity)Iterators.find((Iterator)groups.iterator(), SearchResourceTest.groupEntityHasName(GROUP2))).getAttributes().size(), (int)1);
    }

    private static Predicate<GroupEntity> groupEntityHasName(final String name) {
        return new Predicate<GroupEntity>(){

            public boolean apply(GroupEntity groupEntity) {
                return groupEntity.getName().equalsIgnoreCase(name);
            }
        };
    }

    private static Set<String> getNames(Iterable<? extends NamedEntity> entities) {
        HashSet names = Sets.newHashSet();
        for (NamedEntity namedEntity : entities) {
            names.add(namedEntity.getName());
        }
        return names;
    }

    static {
        ALL_USERNAMES = ImmutableSet.of((Object)USERNAME1, (Object)USERNAME2, (Object)USERNAME3, (Object)USERNAME4, (Object)USERNAME5, (Object)USERNAME6, (Object[])new String[0]);
        TOTAL_NUM_USERS = ALL_USERNAMES.size();
    }
}

