/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.TestDataState;
import com.atlassian.crowd.acceptance.tests.rest.BasicAuthFilter;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import junit.framework.TestCase;

public abstract class RestCrowdServiceAcceptanceTestCase
extends TestCase {
    protected static final String APPLICATION_NAME = "crowd";
    protected static final String APPLICATION_PASSWORD = "qybhDMZh";
    protected static final String GROUPS_RESOURCE = "group";
    protected static final String ATTRIBUTES_RESOURCE = "attribute";
    protected static final String USERS_RESOURCE = "user";
    protected static final String AUTHENTICATION_RESOURCE = "authentication";
    protected static final String SESSION_RESOURCE = "session";
    protected static final String WEBHOOKS_RESOURCE = "webhook";
    protected static final String EVENTS_RESOURCE = "event";
    protected static final MediaType MT = MediaType.APPLICATION_XML_TYPE;
    protected static final String REST_SERVICE_NAME = "usermanagement";
    protected static final String USERNAME_PARAM = "username";
    protected static final String TEST_USERNAME = "eeeep";
    protected static final String TEST_PASSWORD = "eep";
    private RestServer restServer = RestServerImpl.INSTANCE;

    protected RestCrowdServiceAcceptanceTestCase(String name) {
        this(name, (RestServer)RestServerImpl.INSTANCE);
    }

    protected RestCrowdServiceAcceptanceTestCase(String name, RestServer restServer) {
        super(name);
        if (restServer == null) {
            throw new NullPointerException("restServer");
        }
        this.restServer = restServer;
    }

    public void setUp() throws Exception {
        this.restServer.before();
    }

    void intendToModifyData() {
        TestDataState.INSTANCE.intendToModify(this.restServer.getBaseUrl());
    }

    public void tearDown() throws Exception {
        this.restServer.after();
    }

    public final void setRestServer(RestServer restServer) {
        this.restServer = restServer;
    }

    protected UriBuilder getBaseUriBuilder() {
        return this.getBaseUriBuilder(REST_SERVICE_NAME, "1");
    }

    protected UriBuilder getBaseUriBuilder(String serviceName) {
        return UriBuilder.fromUri((String)this.restServer.getBaseUrl().toString()).path("rest").path(serviceName);
    }

    protected UriBuilder getBaseUriBuilder(String serviceName, String version) {
        return this.getBaseUriBuilder(serviceName).path(version);
    }

    protected UriBuilder getServerUriBuilder() {
        return UriBuilder.fromUri((String)this.restServer.getBaseUrl().toString());
    }

    protected WebResource getRootWebResource(String applicationName, String password) {
        URI baseUri = this.getBaseUriBuilder().build(new Object[0]);
        return this.getWebResource(applicationName, password, baseUri);
    }

    protected WebResource getWebResource(String applicationName, String password, URI uri) {
        Client client = Client.create();
        client.addFilter((ClientFilter)new BasicAuthFilter(applicationName, password));
        client = this.restServer.decorateClient(client);
        return client.resource(uri);
    }

    protected WebResource getWebResource(URI uri) {
        Client client = Client.create();
        client = this.restServer.decorateClient(client);
        return client.resource(uri);
    }

    protected static String statusToString(Response.Status status) {
        return String.format("%d (%s)", status.getStatusCode(), status.toString());
    }

    protected UserEntity authenticateUser(String username, String password) {
        return this.authenticateUser(username, password, APPLICATION_NAME, APPLICATION_PASSWORD);
    }

    protected UserEntity authenticateUser(String username, String password, String applicationName, String applicationPassword) {
        URI uri = this.getBaseUriBuilder().path(AUTHENTICATION_RESOURCE).queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{username});
        WebResource webResource = this.getWebResource(applicationName, applicationPassword, uri);
        return (UserEntity)webResource.post(UserEntity.class, (Object)new PasswordEntity(password, null));
    }
}

