/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.plugins.rest.common.Link;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;

public class LowerCaseOutputTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String LOWERCASE_OUTPUT_APPLICATION_NAME = "aliases";
    private static final String LOWERCASE_OUTPUT_APPLICATION_PASSWORD = "aliases";
    private static final String USER_PATH = "user";
    private static final String GROUP_PATH = "group";
    private static final String DIRECT_PATH = "direct";
    private static final String USERNAME_PARAM = "username";
    private static final String GROUPNAME_PARAM = "groupname";
    private static final String MIXED_CASE_USERNAME = "mIxEdCaSeUsErNaMe";
    private static final String MIXED_CASE_GROUPNAME = "mIxEdCaSeGrOuPnAmE";

    public LowerCaseOutputTest(String name) {
        super(name);
    }

    public LowerCaseOutputTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    private UserEntity createMixedCaseUser(String applicationName, String applicationPassword) {
        WebResource webResource = this.getRootWebResource(applicationName, applicationPassword).path(USER_PATH);
        UserTemplate userTemplate = new UserTemplate(MIXED_CASE_USERNAME);
        UserEntity userEntity = EntityTranslator.toUserEntity((User)userTemplate, (Link)Link.self((URI)URI.create("link_to_user")));
        userEntity.setPassword(new PasswordEntity("secret", null));
        webResource.entity((Object)userEntity, MT).post();
        return userEntity;
    }

    private UserEntity getMixedCaseUserEntity(String applicationName, String applicationPassword) {
        WebResource userWebResource = this.getRootWebResource(applicationName, applicationPassword).path(USER_PATH).queryParam(USERNAME_PARAM, MIXED_CASE_USERNAME);
        return (UserEntity)userWebResource.get(UserEntity.class);
    }

    private void createMixedCaseGroup(String applicationName, String applicationPassword) {
        GroupTemplate groupTemplate = new GroupTemplate(MIXED_CASE_GROUPNAME);
        WebResource webResource = this.getRootWebResource(applicationName, applicationPassword).path(GROUP_PATH);
        webResource.entity((Object)EntityTranslator.toGroupEntity((Group)groupTemplate, (URI)this.getRootWebResource(applicationName, applicationPassword).getURI()), MT).post();
    }

    private GroupEntity getMixedCaseGroupEntity(String applicationName, String applicationPassword) {
        WebResource groupWebResource = this.getRootWebResource(applicationName, applicationPassword).path(GROUP_PATH).queryParam(GROUPNAME_PARAM, MIXED_CASE_GROUPNAME);
        return (GroupEntity)groupWebResource.get(GroupEntity.class);
    }

    public void testMixedCaseUsernameTranslatedToLowerCaseForLowerCaseOutputApplication() throws Exception {
        this.intendToModifyData();
        this.createMixedCaseUser("aliases", "aliases");
        UserEntity newUserEntity = this.getMixedCaseUserEntity("aliases", "aliases");
        LowerCaseOutputTest.assertEquals((String)MIXED_CASE_USERNAME.toLowerCase(), (String)newUserEntity.getName());
    }

    public void testMixedCaseUsernameNotTranslatedForMixedCaseOutputApplication() throws Exception {
        this.intendToModifyData();
        this.createMixedCaseUser("crowd", "qybhDMZh");
        UserEntity newUserEntity = this.getMixedCaseUserEntity("crowd", "qybhDMZh");
        LowerCaseOutputTest.assertEquals((String)MIXED_CASE_USERNAME, (String)newUserEntity.getName());
    }

    public void testMixedCaseGroupNameTranslatedToLowerCaseForLowerCaseOutputApplication() throws Exception {
        this.intendToModifyData();
        this.createMixedCaseGroup("aliases", "aliases");
        GroupEntity newGroupEntity = this.getMixedCaseGroupEntity("aliases", "aliases");
        LowerCaseOutputTest.assertEquals((String)MIXED_CASE_GROUPNAME.toLowerCase(), (String)newGroupEntity.getName());
    }

    public void testMixedCaseGroupNameNotTranslatedForMixedCaseOutputApplication() throws Exception {
        this.intendToModifyData();
        this.createMixedCaseGroup("crowd", "qybhDMZh");
        GroupEntity newGroupEntity = this.getMixedCaseGroupEntity("crowd", "qybhDMZh");
        LowerCaseOutputTest.assertEquals((String)MIXED_CASE_GROUPNAME, (String)newGroupEntity.getName());
    }

    public void testMixedCaseGroupnameInMembershipTranslatedToLowerCase() throws Exception {
        this.intendToModifyData();
        UserEntity userEntity = this.createMixedCaseUser("aliases", "aliases");
        this.createMixedCaseGroup("aliases", "aliases");
        WebResource groupUserWebResource = this.getRootWebResource("aliases", "aliases").path(GROUP_PATH).path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, MIXED_CASE_GROUPNAME);
        ClientResponse membershipCreationResponse = (ClientResponse)groupUserWebResource.entity((Object)userEntity, MT).post(ClientResponse.class);
        LowerCaseOutputTest.assertEquals((int)201, (int)membershipCreationResponse.getStatus());
        WebResource userGroupWebResource = this.getRootWebResource("aliases", "aliases").path(USER_PATH).path(GROUP_PATH).path(DIRECT_PATH).queryParam(USERNAME_PARAM, MIXED_CASE_USERNAME);
        GroupEntityList groupsEntity = (GroupEntityList)userGroupWebResource.get(GroupEntityList.class);
        LowerCaseOutputTest.assertEquals((int)1, (int)groupsEntity.size());
        LowerCaseOutputTest.assertEquals((String)MIXED_CASE_GROUPNAME.toLowerCase(), (String)groupsEntity.get(0).getName());
    }
}

