/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.integration.rest.entity.EventEntityList;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class EventsResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    public EventsResourceTest(String name) {
        super(name);
    }

    public EventsResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetEventToken() {
        EventEntityList events = this.requestEventToken();
        Assert.assertThat((Object)events.getNewEventToken(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)events.getEvents(), (Matcher)Matchers.nullValue());
    }

    public void testGetEventsWithBadEventToken() {
        URI uri = this.getBaseUriBuilder().path("event").path("bad-event-token").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)410));
    }

    public void testGetNoEventsWithGoodEventToken() {
        String firstEventToken = this.requestEventToken().getNewEventToken();
        EventEntityList events = this.requestEvents(firstEventToken);
        Assert.assertThat((Object)events.getEvents(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)events.getNewEventToken(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)events.getNewEventToken(), (Matcher)Matchers.is((Object)firstEventToken));
    }

    public void testGetEvents() {
        this.intendToModifyData();
        String firstEventToken = this.requestEventToken().getNewEventToken();
        this.removeUser();
        EventEntityList events = this.requestEvents(firstEventToken);
        Assert.assertThat((Object)events.getEvents(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)events.getNewEventToken(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)events.getNewEventToken(), (Matcher)Matchers.not((Object)firstEventToken));
    }

    private void removeUser() {
        URI uri = this.getBaseUriBuilder().path("user").queryParam("username", new Object[]{"eeeep"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        webResource.delete();
    }

    private EventEntityList requestEventToken() {
        URI uri = this.getBaseUriBuilder().path("event").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        return (EventEntityList)webResource.get(EventEntityList.class);
    }

    private EventEntityList requestEvents(String eventToken) {
        URI uri = this.getBaseUriBuilder().path("event").path(eventToken).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        return (EventEntityList)webResource.get(EventEntityList.class);
    }
}

