/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.StringReader;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CrowdWadlResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String WADL_RESOURCE = "application.wadl";
    private static final String ADMIN_USER_NAME = "admin";
    private static final String ADMIN_PASSWORD = "admin";
    private RestServer restServer = RestServerImpl.INSTANCE;

    public CrowdWadlResourceTest(String name) {
        super(name);
    }

    public CrowdWadlResourceTest(String name, RestServer restServer) {
        super(name);
        this.restServer = restServer;
    }

    @Override
    public void setUp() throws Exception {
        this.restServer.before();
    }

    public void testShouldGetAWadlRepresentationForUserManagement() throws IOException, SAXException, ParserConfigurationException {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path(WADL_RESOURCE);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        CrowdWadlResourceTest.assertEquals((int)200, (int)response.getStatus());
        String wadlRepresentation = (String)webResource.get(String.class);
        CrowdWadlResourceTest.assertNotNull((Object)wadlRepresentation);
        Document document = this.parseXMLDocument(wadlRepresentation);
        CrowdWadlResourceTest.assertNotNull((Object)document);
        Element documentElement = document.getDocumentElement();
        MatcherAssert.assertThat((Object)documentElement.getNodeName(), (Matcher)CoreMatchers.containsString((String)"application"));
    }

    public void testShouldGetAWadlRepresentationForAppManagement() throws IOException, SAXException, ParserConfigurationException {
        UriBuilder path = this.getBaseUriBuilder("appmanagement", "1").path(WADL_RESOURCE);
        WebResource webResource = this.getWebResource("admin", "admin", path.build(new Object[0]));
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        CrowdWadlResourceTest.assertEquals((int)200, (int)response.getStatus());
        String wadlRepresentation = (String)webResource.get(String.class);
        CrowdWadlResourceTest.assertNotNull((Object)wadlRepresentation);
        Document document = this.parseXMLDocument(wadlRepresentation);
        CrowdWadlResourceTest.assertNotNull((Object)document);
        Element documentElement = document.getDocumentElement();
        MatcherAssert.assertThat((Object)documentElement.getNodeName(), (Matcher)CoreMatchers.containsString((String)"application"));
    }

    private Document parseXMLDocument(String wadlRepresentation) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(wadlRepresentation)));
    }
}

