/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.integration.rest.entity.CookieConfigEntity;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CookieConfigResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String CONFIG_COOKIE_RESOURCE = "config/cookie";

    public CookieConfigResourceTest(String name) {
        super(name);
    }

    public CookieConfigResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetConfig() throws Exception {
        URI uri = this.getBaseUriBuilder().path(CONFIG_COOKIE_RESOURCE).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        CookieConfigEntity config = (CookieConfigEntity)webResource.get(CookieConfigEntity.class);
        CookieConfigResourceTest.assertEquals((String)"", (String)config.getDomain());
        CookieConfigResourceTest.assertEquals((String)this.getExpectedCookieName(), (String)config.getName());
        CookieConfigResourceTest.assertEquals((boolean)this.getExpectedCookieSecure(), (boolean)config.isSecure());
    }

    public void testConfigSpecifiesCacheControlToAllowCaching() throws Exception {
        URI uri = this.getBaseUriBuilder().path(CONFIG_COOKIE_RESOURCE).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        String cacheControl = (String)response.getHeaders().getFirst((Object)"Cache-Control");
        Pattern maxAge = Pattern.compile("(?:,|^)\\s*max-age\\s*=\\s*(.*?)\\s*(?:,|$)");
        Matcher m = maxAge.matcher(cacheControl);
        CookieConfigResourceTest.assertTrue((String)("Cache-Control should indicate max-age: " + cacheControl), (boolean)m.find());
        Assert.assertThat((Object)Integer.parseInt(m.group(1)), (org.hamcrest.Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    protected String getExpectedCookieName() {
        return "crowd.token_key";
    }

    protected boolean getExpectedCookieSecure() {
        return false;
    }
}

