/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.sun.jersey.api.client.UniformInterfaceException;
import javax.ws.rs.core.Response;

public class AuthenticationResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String NON_EXISTENT_USERNAME = "non-existent";

    public AuthenticationResourceTest(String name) {
        super(name);
    }

    public AuthenticationResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testUserAuthentication() {
        UserEntity userEntity = this.authenticateUser("eeeep", "eep");
        AuthenticationResourceTest.assertNotNull((Object)userEntity);
        AuthenticationResourceTest.assertEquals((String)"eeeep", (String)userEntity.getName());
    }

    public void testUserAuthentication_BadCredentials() {
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        try {
            this.authenticateUser("eeeep", "I am a bad credential");
            AuthenticationResourceTest.fail((String)(AuthenticationResourceTest.statusToString(expectedStatus) + " expected"));
        }
        catch (UniformInterfaceException e) {
            AuthenticationResourceTest.assertEquals((int)expectedStatus.getStatusCode(), (int)e.getResponse().getStatus());
        }
    }

    public void testUserAuthentication_NoUser() {
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        try {
            this.authenticateUser(NON_EXISTENT_USERNAME, "eep");
            AuthenticationResourceTest.fail((String)(AuthenticationResourceTest.statusToString(expectedStatus) + " expected"));
        }
        catch (UniformInterfaceException e) {
            AuthenticationResourceTest.assertEquals((int)expectedStatus.getStatusCode(), (int)e.getResponse().getStatus());
        }
    }

    public void testUserAuthentication_UnauthorisedGroupUser() {
        String UNAUTHORISED_USERNAME = "dir1user";
        String UNAUTHORISED_USER_PASSWORD = "dir1user";
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        try {
            this.authenticateUser("dir1user", "dir1user");
            AuthenticationResourceTest.fail((String)(AuthenticationResourceTest.statusToString(expectedStatus) + " expected"));
        }
        catch (UniformInterfaceException e) {
            AuthenticationResourceTest.assertEquals((int)expectedStatus.getStatusCode(), (int)e.getResponse().getStatus());
            ErrorEntity errorEntity = (ErrorEntity)e.getResponse().getEntity(ErrorEntity.class);
            AuthenticationResourceTest.assertNotNull((Object)errorEntity);
            AuthenticationResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.INVALID_USER_AUTHENTICATION, (Object)errorEntity.getReason());
        }
    }

    public void testUserAuthentication_AllowAllToAuthenticate() {
        this.authenticateUser("regularuser", "regularuser");
    }

    public void testUserAuthentication_CommonUserUnauthorised() {
        this.authenticateUser("secondadmin", "secondadmin");
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        try {
            this.authenticateUser("secondadmin", "secondadmindir2");
            AuthenticationResourceTest.fail((String)(AuthenticationResourceTest.statusToString(expectedStatus) + " expected"));
        }
        catch (UniformInterfaceException e) {
            AuthenticationResourceTest.assertEquals((int)expectedStatus.getStatusCode(), (int)e.getResponse().getStatus());
            ErrorEntity errorEntity = (ErrorEntity)e.getResponse().getEntity(ErrorEntity.class);
            AuthenticationResourceTest.assertNotNull((Object)errorEntity);
            AuthenticationResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.INVALID_USER_AUTHENTICATION, (Object)errorEntity.getReason());
        }
    }

    public void testUserAuthentication_NestedUser() {
        this.authenticateUser("penny", "penny");
    }
}

