/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.integration.rest.entity.EventEntityList;
import com.atlassian.crowd.integration.rest.entity.UserEventEntity;
import com.atlassian.crowd.plugin.rest.entity.WebhookEntity;
import com.google.common.util.concurrent.SettableFuture;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhooksResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final Logger logger = LoggerFactory.getLogger(WebhooksResourceTest.class);

    public WebhooksResourceTest(String name) {
        super(name);
    }

    public WebhooksResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetNonExistingWebhook() throws Exception {
        URI uri = this.getBaseUriBuilder().path("webhook").path("not-a-webhook-id").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        try {
            webResource.get(WebhookEntity.class);
            WebhooksResourceTest.fail((String)"Exception expected");
        }
        catch (UniformInterfaceException e) {
            WebhooksResourceTest.assertEquals((int)404, (int)e.getResponse().getStatus());
        }
    }

    public void testRegisterAndGetWebhook() throws Exception {
        this.intendToModifyData();
        ClientResponse registrationResponse = this.registerWebhook("http://example.test/", "secret");
        WebhooksResourceTest.assertEquals((int)201, (int)registrationResponse.getStatus());
        WebhooksResourceTest.assertTrue((boolean)registrationResponse.getHeaders().containsKey((Object)"Location"));
        WebhookEntity registrationResponseEntity = (WebhookEntity)registrationResponse.getEntity(WebhookEntity.class);
        WebhooksResourceTest.assertNotNull((Object)registrationResponseEntity.getId());
        WebhooksResourceTest.assertEquals((String)"http://example.test/", (String)registrationResponseEntity.getEndpointUrl());
        URI webhookResourceUri = new URI((String)registrationResponse.getHeaders().getFirst((Object)"Location"));
        WebResource webhookResource = this.getWebResource("crowd", "qybhDMZh", webhookResourceUri);
        WebhookEntity webhookEntity = (WebhookEntity)webhookResource.get(WebhookEntity.class);
        WebhooksResourceTest.assertTrue((boolean)webhookResourceUri.getPath().endsWith("/" + webhookEntity.getId()));
        WebhooksResourceTest.assertEquals((String)"http://example.test/", (String)webhookEntity.getEndpointUrl());
    }

    public void testRegisterWebhookWithInvalidEndpointUrlShouldFail() throws Exception {
        ClientResponse registrationResponse = this.registerWebhook("ftp://example.test/", "secret");
        WebhooksResourceTest.assertEquals((int)400, (int)registrationResponse.getStatus());
    }

    public void testRegisterWebhookWithSimpleBody() throws Exception {
        this.intendToModifyData();
        URI uri = this.getBaseUriBuilder().path("webhook").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        ClientResponse registrationResponse = (ClientResponse)webResource.entity((Object)"http://example.test/", MediaType.TEXT_PLAIN_TYPE).post(ClientResponse.class);
        WebhooksResourceTest.assertEquals((int)201, (int)registrationResponse.getStatus());
        WebhooksResourceTest.assertTrue((boolean)registrationResponse.getHeaders().containsKey((Object)"Location"));
    }

    public void testRegisterAndUnregisterWebhook() throws Exception {
        this.intendToModifyData();
        ClientResponse registrationResponse = this.registerWebhook("http://example.test/", "secret");
        WebhooksResourceTest.assertTrue((boolean)registrationResponse.getHeaders().containsKey((Object)"Location"));
        URI webhookResourceUri = new URI((String)registrationResponse.getHeaders().getFirst((Object)"Location"));
        this.unregisterWebhook(webhookResourceUri);
    }

    public void testUnregisterNonExistingWebhook() throws Exception {
        URI uri = this.getBaseUriBuilder().path("webhook").path("not-a-webhook-id").build(new Object[0]);
        try {
            this.unregisterWebhook(uri);
            WebhooksResourceTest.fail((String)"Exception expected");
        }
        catch (UniformInterfaceException e) {
            WebhooksResourceTest.assertEquals((int)404, (int)e.getResponse().getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWebhookFullCycle() throws Exception {
        this.intendToModifyData();
        final SettableFuture futureEvents = SettableFuture.create();
        final String eventToken = this.requestEventToken().getNewEventToken();
        InetSocketAddress addr = new InetSocketAddress(0);
        HttpServer server = HttpServer.create(addr, 0);
        server.setExecutor(Executors.newCachedThreadPool());
        server.createContext("/myapp", new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                logger.info("Received Webhook callback!");
                Assert.assertThat((Object)httpExchange.getRequestHeaders().get("Authorization"), (Matcher)Matchers.hasItem((Object)"Basic secret"));
                try {
                    List events = WebhooksResourceTest.this.requestEvents(eventToken).getEvents();
                    futureEvents.set((Object)events);
                    httpExchange.sendResponseHeaders(204, 0L);
                }
                catch (Exception e) {
                    futureEvents.cancel(false);
                    throw new RuntimeException(e);
                }
                finally {
                    httpExchange.close();
                }
            }
        });
        String webhookUrl = "http://localhost:" + server.getAddress().getPort() + "/myapp/mywebhook";
        try {
            server.start();
            ClientResponse registerWebhookResponse = this.registerWebhook(webhookUrl, "secret");
            this.removeUser();
            this.unregisterWebhook(registerWebhookResponse.getLocation());
            List events = (List)futureEvents.get(10L, TimeUnit.SECONDS);
            Assert.assertThat((Object)events, (Matcher)IsCollectionContaining.hasItem((Matcher)IsInstanceOf.instanceOf(UserEventEntity.class)));
        }
        finally {
            server.stop(0);
        }
    }

    private ClientResponse registerWebhook(String endpointUrl, String password) {
        URI uri = this.getBaseUriBuilder().path("webhook").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        WebhookEntity webhookTemplate = new WebhookEntity(endpointUrl, password);
        return (ClientResponse)webResource.entity((Object)webhookTemplate, MT).post(ClientResponse.class);
    }

    private void unregisterWebhook(URI webhookResourceUri) {
        WebResource webhookResource = this.getWebResource("crowd", "qybhDMZh", webhookResourceUri);
        webhookResource.delete();
    }

    private EventEntityList requestEventToken() {
        URI uri = this.getBaseUriBuilder().path("event").build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        return (EventEntityList)webResource.get(EventEntityList.class);
    }

    private EventEntityList requestEvents(String eventToken) {
        URI uri = this.getBaseUriBuilder().path("event").path(eventToken).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        return (EventEntityList)webResource.get(EventEntityList.class);
    }

    private void removeUser() {
        URI uri = this.getBaseUriBuilder().path("user").queryParam("username", new Object[]{"eeeep"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        webResource.delete();
    }
}

