/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class RepresentationTest
extends RestCrowdServiceAcceptanceTestCase {
    private final MediaType mediaType;
    private final Map<String, String> expectedRepresentationForResource;

    RepresentationTest(String name, MediaType mediaType) throws IOException {
        super(name);
        this.mediaType = mediaType;
        this.expectedRepresentationForResource = this.loadExpectedRepresentations();
    }

    RepresentationTest(String name, MediaType mediaType, RestServer restServer) throws IOException {
        super(name, restServer);
        this.mediaType = mediaType;
        this.expectedRepresentationForResource = this.loadExpectedRepresentations();
    }

    Map<String, String> loadExpectedRepresentations() throws IOException {
        ImmutableMap.Builder mb = ImmutableMap.builder();
        RepresentationTest.assertEquals((String)"application", (String)this.mediaType.getType());
        String type = this.mediaType.getSubtype();
        URL url = RepresentationTest.class.getResource("RepresentationTest-samples-" + type + ".txt");
        RepresentationTest.assertNotNull((Object)url);
        List lines = IOUtils.readLines((InputStream)url.openStream());
        String id = null;
        StringBuilder value = new StringBuilder();
        for (String l : lines) {
            if (id == null) {
                Assert.assertThat((Object)l, (Matcher)CoreMatchers.not((Object)""));
                id = l;
                value.setLength(0);
                continue;
            }
            if (l.equals("")) {
                mb.put((Object)id, (Object)value.toString());
                id = null;
                continue;
            }
            value.append(l);
        }
        RepresentationTest.assertNull(id);
        return mb.build();
    }

    private void assertGetIsAsExpected(String resource) throws Exception {
        this.assertGetIsAsExpected(resource, 200);
    }

    private boolean isJson() {
        if (this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return false;
        }
        if (this.mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return true;
        }
        throw new IllegalStateException("Unexpected media type for test: " + this.mediaType);
    }

    private Object parse(String s) throws Exception {
        if (this.isJson()) {
            return new ObjectMapper().readTree(s);
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(s)));
        StringWriter sw = new StringWriter();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(sw));
        return sw.toString();
    }

    private String get(String resource, int statusCode) throws Exception {
        Assert.assertThat((Object)resource, (Matcher)Matchers.startsWith((String)"/"));
        URI ref = URI.create(resource.substring(1));
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").uri(ref);
        WebResource.Builder builder = webResource.accept(new MediaType[]{this.mediaType});
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        RepresentationTest.assertEquals((int)statusCode, (int)response.getStatus());
        return (String)response.getEntity(String.class);
    }

    private void assertGetIsAsExpected(String resource, int statusCode) throws Exception {
        String result = this.get(resource, statusCode);
        this.assertParsedEquals(this.expectedRepresentationForResource.get(resource), result);
    }

    private String postAndRetrieve(String resource, String body, int statusCode) {
        Preconditions.checkNotNull((Object)body);
        Assert.assertThat((Object)resource, (Matcher)Matchers.startsWith((String)"/"));
        URI ref = URI.create(resource.substring(1));
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").uri(ref);
        WebResource.Builder builder = webResource.accept(new MediaType[]{this.mediaType});
        ClientResponse response = (ClientResponse)((WebResource.Builder)builder.entity((Object)body, this.mediaType)).post(ClientResponse.class);
        RepresentationTest.assertEquals((int)statusCode, (int)response.getStatus());
        String result = (String)response.getEntity(String.class);
        return result;
    }

    public void testCookieConfig() throws Exception {
        this.assertGetIsAsExpected("/config/cookie");
    }

    public void testUser() throws Exception {
        String response = this.get("/user?username=admin", 200);
        this.assertParsedEquals(this.removeRandomnessFromUserRepresentation(this.expectedRepresentationForResource.get("/user?username=admin")), this.removeRandomnessFromUserRepresentation(response));
    }

    private String removeRandomnessFromUserRepresentation(String user) {
        if (this.isJson()) {
            return user.replaceAll("\"key\"\\s*:\\s*\"[^\"]+\"", "\"key\":\"MASKED-RANDOM-VALUE\"");
        }
        return user.replaceAll("<key>[^<]+</key>", "<key>MASKED-RANDOM-VALUE</key>");
    }

    public void testUserAttributes() throws Exception {
        this.assertGetIsAsExpected("/user/attribute?username=dir1user");
    }

    public void testGroup() throws Exception {
        this.assertGetIsAsExpected("/group?groupname=crowd-administrators");
    }

    public void testUserList() throws Exception {
        this.assertGetIsAsExpected("/search?entity-type=user&restriction=name%3Dadmin");
    }

    public void testGroupList() throws Exception {
        this.assertGetIsAsExpected("/search?entity-type=group&restriction=name%3Dcrowd-administrators");
    }

    public void testGetErrorEntity() throws Exception {
        this.assertGetIsAsExpected("/search?entity-type=no-such-entity-type", 400);
    }

    String sanitiseSession(String session) {
        String withTokenBlanked = this.isJson() ? session.replaceAll("\"token\"\\s*:\\s*\"[^\"]{24}\"", "\"token\":\"RANDOM-TOKEN\"") : session.replaceAll("<token>[^<]{24}</token>", "<token>RANDOM-TOKEN</token>");
        String tokenBlankedInSelfLink = withTokenBlanked.replaceAll("/usermanagement/1/session/\\w{24}\"", "/usermanagement/1/session/RANDOM-TOKEN\"");
        String datesRemoved = this.isJson() ? tokenBlankedInSelfLink.replaceAll("-date\"\\s*:\\s*\\d+", "-date\":1234567890") : tokenBlankedInSelfLink.replaceAll("-date>....-..-..T..:..:..(\\....)?(...:..|Z)<", "-date>DATE<");
        return datesRemoved;
    }

    private void assertParsedEquals(String expected, String actual) throws Exception {
        Object e = this.parse(expected);
        Object a = this.parse(actual);
        if (e instanceof String && a instanceof String) {
            RepresentationTest.assertEquals((String)((String)e), (String)((String)a));
        } else {
            RepresentationTest.assertEquals((Object)e, (Object)a);
        }
    }

    public void testPostAuthenticationContextEntity() throws Exception {
        String payload = this.expectedRepresentationForResource.get("/session request");
        String response = this.postAndRetrieve("/session", payload, 201);
        this.assertParsedEquals(this.sanitiseSession(this.expectedRepresentationForResource.get("/session response")), this.sanitiseSession(response));
    }

    public void testPasswordEntity() throws Exception {
        String payload = this.expectedRepresentationForResource.get("/authentication?username=admin request");
        String response = this.postAndRetrieve("/authentication?username=admin", payload, 200);
        RepresentationTest.assertNotNull((Object)this.parse(response));
    }

    public void testSearchRestrictionEntity() throws Exception {
        String payload = this.expectedRepresentationForResource.get("/search request");
        String response = this.postAndRetrieve("/search?entity-type=user", payload, 200);
        RepresentationTest.assertNotNull((Object)this.parse(response));
    }

    private String sanitiseEvents(String events) {
        if (this.isJson()) {
            return events.replaceAll("\"newEventToken\"\\s*:\\s*\"[^\"]*\"", "\"newEventToken\":\"TOKEN\"");
        }
        return events.replaceAll("newEventToken=\"[^\"]*\"", "newEventToken=\"TOKEN\"");
    }

    public void testEventEntityList() throws Exception {
        String response = this.get("/event", 200);
        this.assertParsedEquals(this.sanitiseEvents(this.expectedRepresentationForResource.get("/event")), this.sanitiseEvents(response));
    }
}

