/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.TestDataState;
import com.atlassian.crowd.acceptance.tests.rest.BasicAuthFilter;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.ApplicationErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntitySet;
import com.atlassian.crowd.plugin.rest.util.ApplicationEntityTranslator;
import com.atlassian.crowd.plugin.rest.util.ApplicationLinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApplicationResourceTest {
    private static final MediaType MT = RestCrowdServiceAcceptanceTestCase.MT;
    private static final String X_FORWARDED_FOR_HEADER_NAME = "X-Forwarded-For";
    protected static final String USER_NAME = "admin";
    protected static final String USER_PASSWORD = "admin";
    protected static final String APPLICATION_RESOURCE = "application";
    protected static final long CROWD_APPLICATION_ID = 163841L;
    protected static final String CROWD_APPLICATION_NAME = "crowd";
    protected static final String REST_SERVICE_NAME = "appmanagement";
    private RestServer restServer = RestServerImpl.INSTANCE;

    @Before
    public void setUp() throws Exception {
        this.restServer.before();
    }

    @After
    public void tearDown() throws Exception {
        this.restServer.after();
    }

    void intendToModifyData() {
        TestDataState.INSTANCE.intendToModify(this.restServer.getBaseUrl());
    }

    protected long getApplicationId() {
        return 163841L;
    }

    protected String getApplicationName() {
        return CROWD_APPLICATION_NAME;
    }

    protected ApplicationType getApplicationType() {
        return ApplicationType.CROWD;
    }

    protected UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((String)this.restServer.getBaseUrl().toString()).path("rest").path(REST_SERVICE_NAME).path("1");
    }

    protected WebResource getRootWebResource(String userName, String password) {
        URI baseUri = this.getBaseUriBuilder().build(new Object[0]);
        return this.getWebResource(userName, password, baseUri);
    }

    protected WebResource getWebResource(String userName, String password, URI uri) {
        Client client = Client.create();
        client.addFilter((ClientFilter)new BasicAuthFilter(userName, password));
        client = this.restServer.decorateClient(client);
        return client.resource(uri);
    }

    @Test
    public void testGetApplicationByName() throws Exception {
        URI uri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).queryParam("name", new Object[]{"{appname}"}).build(new Object[]{this.getApplicationName()});
        WebResource webResource = this.getWebResource("admin", "admin", uri);
        ApplicationEntity applicationEntity = (ApplicationEntity)webResource.get(ApplicationEntity.class);
        Assert.assertEquals((Object)this.getApplicationName(), (Object)applicationEntity.getName());
        Assert.assertEquals((Object)this.getApplicationType().name(), (Object)applicationEntity.getType().toUpperCase());
        Assert.assertTrue((boolean)applicationEntity.isActive());
        Assert.assertNull((Object)applicationEntity.getPassword());
    }

    @Test
    public void testGetApplicationByName_NotFound() throws Exception {
        URI uri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).queryParam("name", new Object[]{"{appname}"}).build(new Object[]{"non-existent"});
        WebResource webResource = this.getWebResource("admin", "admin", uri);
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        ApplicationErrorEntity applicationErrorEntity = (ApplicationErrorEntity)clientResponse.getEntity(ApplicationErrorEntity.class);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)clientResponse.getStatus());
        Assert.assertEquals((Object)ApplicationErrorEntity.ErrorReason.APPLICATION_NOT_FOUND, (Object)applicationErrorEntity.getReason());
    }

    @Test
    public void testGetApplicationById() throws Exception {
        URI uri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).path(String.valueOf(this.getApplicationId())).build(new Object[0]);
        WebResource webResource = this.getWebResource("admin", "admin", uri);
        ApplicationEntity applicationEntity = (ApplicationEntity)webResource.get(ApplicationEntity.class);
        Assert.assertEquals((Object)this.getApplicationName(), (Object)applicationEntity.getName());
        Assert.assertEquals((Object)this.getApplicationType().name(), (Object)applicationEntity.getType().toUpperCase());
        Assert.assertTrue((boolean)applicationEntity.isActive());
        Assert.assertNull((Object)applicationEntity.getPassword());
    }

    @Test
    public void testGetApplicationById_NotFound() throws Exception {
        URI uri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).path("-1").build(new Object[0]);
        WebResource webResource = this.getWebResource("admin", "admin", uri);
        ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
        ApplicationErrorEntity applicationErrorEntity = (ApplicationErrorEntity)clientResponse.getEntity(ApplicationErrorEntity.class);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)clientResponse.getStatus());
        Assert.assertEquals((Object)ApplicationErrorEntity.ErrorReason.APPLICATION_NOT_FOUND, (Object)applicationErrorEntity.getReason());
    }

    @Test
    public void testWrongPassword() throws Exception {
        URI uri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).path("1").build(new Object[0]);
        WebResource webResource = this.getWebResource("admin", "badpassword", uri);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testAddApplication() throws Exception {
        this.intendToModifyData();
        ImmutableSet remoteAddresses = ImmutableSet.of((Object)new RemoteAddress("::1"), (Object)new RemoteAddress("myhost"));
        ImmutableApplication application = ImmutableApplication.builder((String)"mynewapp", (ApplicationType)ApplicationType.BAMBOO).setDescription("My Bamboo App").setRemoteAddresses((Set)remoteAddresses).setPasswordCredential(PasswordCredential.unencrypted((String)"myapppassword")).setActive(true).build();
        ApplicationEntity applicationEntity = ApplicationEntityTranslator.toApplicationEntity((Application)application, (Link)Link.self((URI)URI.create("link_to_application")), (ApplicationEntityTranslator.PasswordMode)ApplicationEntityTranslator.PasswordMode.INCLUDE_PASSWORD);
        URI addApplicationUri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).build(new Object[0]);
        WebResource addApplicationWebResource = this.getWebResource("admin", "admin", addApplicationUri);
        ClientResponse response = (ClientResponse)addApplicationWebResource.entity((Object)applicationEntity, MT).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String applicationLocation = (String)response.getHeaders().getFirst((Object)"Location");
        Assert.assertNotNull((Object)applicationLocation);
        URI applicationUri = URI.create(applicationLocation);
        WebResource applicationWebResource = this.getWebResource("admin", "admin", applicationUri);
        ApplicationEntity createdApplication = (ApplicationEntity)applicationWebResource.get(ApplicationEntity.class);
        Assert.assertEquals((Object)"mynewapp", (Object)createdApplication.getName());
        Assert.assertEquals((Object)ApplicationType.BAMBOO.name(), (Object)createdApplication.getType().toUpperCase());
        Assert.assertTrue((boolean)createdApplication.isActive());
        Assert.assertNull((Object)createdApplication.getPassword());
        HashSet expectedRemoteAddresses = Sets.newHashSet((Object[])new String[]{"::1", "myhost"});
        HashSet actualRemoteAddresses = Sets.newHashSet();
        for (RemoteAddressEntity remoteAddressEntity : createdApplication.getRemoteAddresses()) {
            actualRemoteAddresses.add(remoteAddressEntity.getValue());
        }
        Assert.assertEquals((Object)expectedRemoteAddresses, (Object)actualRemoteAddresses);
    }

    @Test
    public void testAddApplication_NoPassword() throws Exception {
        ImmutableApplication application = ImmutableApplication.builder((String)"mynewapp", (ApplicationType)ApplicationType.BAMBOO).setDescription("My Bamboo App").setActive(true).build();
        ApplicationEntity applicationEntity = ApplicationEntityTranslator.toApplicationEntity((Application)application, (Link)Link.self((URI)URI.create("link_to_application")), (ApplicationEntityTranslator.PasswordMode)ApplicationEntityTranslator.PasswordMode.INCLUDE_PASSWORD);
        URI addApplicationUri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).build(new Object[0]);
        WebResource addApplicationWebResource = this.getWebResource("admin", "admin", addApplicationUri);
        ClientResponse response = (ClientResponse)addApplicationWebResource.entity((Object)applicationEntity, MT).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        ApplicationErrorEntity applicationErrorEntity = (ApplicationErrorEntity)response.getEntity(ApplicationErrorEntity.class);
        Assert.assertEquals((Object)ApplicationErrorEntity.ErrorReason.INVALID_CREDENTIAL, (Object)applicationErrorEntity.getReason());
    }

    @Test
    public void testAddApplication_NoName() throws Exception {
        ImmutableApplication application = ImmutableApplication.builder(null, (ApplicationType)ApplicationType.BAMBOO).setDescription("My Bamboo App").setPasswordCredential(PasswordCredential.unencrypted((String)"myapppassword")).setActive(true).build();
        ApplicationEntity applicationEntity = ApplicationEntityTranslator.toApplicationEntity((Application)application, (Link)Link.self((URI)URI.create("link_to_application")), (ApplicationEntityTranslator.PasswordMode)ApplicationEntityTranslator.PasswordMode.INCLUDE_PASSWORD);
        URI addApplicationUri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).build(new Object[0]);
        WebResource addApplicationWebResource = this.getWebResource("admin", "admin", addApplicationUri);
        ClientResponse response = (ClientResponse)addApplicationWebResource.entity((Object)applicationEntity, MT).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        ApplicationErrorEntity applicationErrorEntity = (ApplicationErrorEntity)response.getEntity(ApplicationErrorEntity.class);
        Assert.assertEquals((Object)ApplicationErrorEntity.ErrorReason.ILLEGAL_ARGUMENT, (Object)applicationErrorEntity.getReason());
    }

    @Test
    public void testAddApplication_NoType() throws Exception {
        ImmutableApplication application = ImmutableApplication.builder((String)"mynewapp", (ApplicationType)ApplicationType.BAMBOO).setDescription("My Bamboo App").setPasswordCredential(PasswordCredential.unencrypted((String)"myapppassword")).setActive(true).build();
        ApplicationEntity applicationEntity = ApplicationEntityTranslator.toApplicationEntity((Application)application, (Link)Link.self((URI)URI.create("link_to_application")), (ApplicationEntityTranslator.PasswordMode)ApplicationEntityTranslator.PasswordMode.INCLUDE_PASSWORD);
        applicationEntity.setType(null);
        URI addApplicationUri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).build(new Object[0]);
        WebResource addApplicationWebResource = this.getWebResource("admin", "admin", addApplicationUri);
        ClientResponse response = (ClientResponse)addApplicationWebResource.entity((Object)applicationEntity, MT).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        ApplicationErrorEntity applicationErrorEntity = (ApplicationErrorEntity)response.getEntity(ApplicationErrorEntity.class);
        Assert.assertEquals((Object)ApplicationErrorEntity.ErrorReason.ILLEGAL_ARGUMENT, (Object)applicationErrorEntity.getReason());
    }

    @Test
    public void testAddRemoteAddress() throws Exception {
        this.intendToModifyData();
        RemoteAddressEntity newAddressEntity = new RemoteAddressEntity("1.2.3.4", Link.self((URI)URI.create("link_to_address")));
        URI addRemoteAddressUri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).path(String.valueOf(this.getApplicationId())).path("remote_address").build(new Object[0]);
        WebResource addApplicationWebResource = this.getWebResource("admin", "admin", addRemoteAddressUri);
        ClientResponse response = (ClientResponse)addApplicationWebResource.entity((Object)newAddressEntity, MT).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String remoteAddressLocation = (String)response.getHeaders().getFirst((Object)"Location");
        Assert.assertNotNull((Object)remoteAddressLocation);
        URI applicationUri = ApplicationLinkUriHelper.buildApplicationUri((URI)this.getBaseUriBuilder().build(new Object[0]), (Long)this.getApplicationId());
        URI remoteAddressesUri = ApplicationLinkUriHelper.buildRemoteAddressesUri((URI)applicationUri);
        WebResource applicationWebResource = this.getWebResource("admin", "admin", remoteAddressesUri);
        RemoteAddressEntitySet remoteAddressEntities = (RemoteAddressEntitySet)applicationWebResource.get(RemoteAddressEntitySet.class);
        HashSet actualRemoteAddresses = Sets.newHashSet();
        for (RemoteAddressEntity remoteAddressEntity : remoteAddressEntities) {
            actualRemoteAddresses.add(remoteAddressEntity.getValue());
        }
        Assert.assertTrue((boolean)actualRemoteAddresses.contains("1.2.3.4"));
    }

    @Test
    public void testAddApplicationWithRequestAddress() {
        this.intendToModifyData();
        String appName = "mynewapp";
        String appPassword = "myapppassword";
        Map<String, String> httpHeaders = Collections.emptyMap();
        this.addApplicationIncludingRequestAddress("mynewapp", "myapppassword", httpHeaders);
        this.connectAsApplication("mynewapp", "myapppassword", httpHeaders);
    }

    @Test
    public void testAddApplicationWithRequestAddress_WithProxy() {
        this.intendToModifyData();
        String appName = "mynewapp";
        String appPassword = "myapppassword";
        String xffHeader = "127.0.0.1, 1.2.3.4";
        Map<String, String> httpHeaders = Collections.singletonMap(X_FORWARDED_FOR_HEADER_NAME, "127.0.0.1, 1.2.3.4");
        this.addApplicationIncludingRequestAddress("mynewapp", "myapppassword", httpHeaders);
        this.connectAsApplication("mynewapp", "myapppassword", httpHeaders);
    }

    private void addApplicationIncludingRequestAddress(String appName, String appPassword, Map<String, String> httpHeaders) {
        this.intendToModifyData();
        ImmutableApplication application = ImmutableApplication.builder((String)appName, (ApplicationType)ApplicationType.BAMBOO).setDescription("My Bamboo App").setPasswordCredential(PasswordCredential.unencrypted((String)appPassword)).setActive(true).build();
        ApplicationEntity applicationEntity = ApplicationEntityTranslator.toApplicationEntity((Application)application, (Link)Link.self((URI)URI.create("link_to_application")), (ApplicationEntityTranslator.PasswordMode)ApplicationEntityTranslator.PasswordMode.INCLUDE_PASSWORD);
        URI addApplicationUri = this.getBaseUriBuilder().path(APPLICATION_RESOURCE).queryParam("include-request-address", new Object[]{"true"}).build(new Object[0]);
        WebResource addApplicationWebResource = this.getWebResource("admin", "admin", addApplicationUri);
        for (Map.Entry<String, String> header : httpHeaders.entrySet()) {
            addApplicationWebResource.header(header.getKey(), (Object)header.getValue());
        }
        ClientResponse response = (ClientResponse)addApplicationWebResource.entity((Object)applicationEntity, MT).post(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String applicationLocation = (String)response.getHeaders().getFirst((Object)"Location");
        Assert.assertNotNull((Object)applicationLocation);
        URI applicationUri = URI.create(applicationLocation);
        WebResource applicationWebResource = this.getWebResource("admin", "admin", applicationUri);
        ApplicationEntity createdApplication = (ApplicationEntity)applicationWebResource.get(ApplicationEntity.class);
        Assert.assertEquals((Object)"mynewapp", (Object)createdApplication.getName());
        Assert.assertEquals((Object)ApplicationType.BAMBOO.name(), (Object)createdApplication.getType().toUpperCase());
        Assert.assertTrue((boolean)createdApplication.isActive());
        Assert.assertNull((Object)createdApplication.getPassword());
    }

    private void connectAsApplication(String appName, String appPassword, Map<String, String> httpHeaders) {
        URI baseUri = UriBuilder.fromUri((String)this.restServer.getBaseUrl().toString()).path("rest").path("usermanagement").path("1").build(new Object[0]);
        URI getAllUsersUri = UriBuilder.fromUri((URI)baseUri).path("search").queryParam("entity-type", new Object[]{"user"}).build(new Object[0]);
        WebResource getAllUsersWebResource = this.getWebResource(appName, appPassword, getAllUsersUri);
        for (Map.Entry<String, String> header : httpHeaders.entrySet()) {
            getAllUsersWebResource.header(header.getKey(), (Object)header.getValue());
        }
        ClientResponse connectAppResponse = (ClientResponse)getAllUsersWebResource.get(ClientResponse.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)connectAppResponse.getStatus());
        Assert.assertNotNull((Object)connectAppResponse.getHeaders().get((Object)"X-Embedded-Crowd-Version"));
    }

    public RestServer getRestServer() {
        return this.restServer;
    }

    public void setRestServer(RestServer restServer) {
        this.restServer = restServer;
    }
}

