/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.google.common.collect.Iterators;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Iterator;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class AliasResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    public static final String ADMIN_NAME = "admin";
    public static final String ADMIN_PASSWORD = "admin";
    public static final String APPLICATION_ID = "884737";
    public static final String MISSING_APPLICATION_ID = "0";

    public AliasResourceTest(String name) {
        this(name, (RestServer)RestServerImpl.INSTANCE);
    }

    public AliasResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    private final UriBuilder aliasesBase() {
        return this.getBaseUriBuilder("appmanagement").path("aliases");
    }

    private WebResource getAliasResource(String applicationId, String username) {
        URI uri = this.aliasesBase().path(applicationId).path("alias").queryParam("user", new Object[]{username}).build(new Object[0]);
        return this.getWebResource("admin", "admin", uri);
    }

    private WebResource getUsernameFromAliasResource(String applicationId, String alias) {
        URI uri = this.aliasesBase().path(applicationId).path("username").queryParam("alias", new Object[]{alias}).build(new Object[0]);
        return this.getWebResource("admin", "admin", uri);
    }

    public void testGetAliasForAliasedUserReturnsAlias() {
        WebResource webResource = this.getAliasResource(APPLICATION_ID, "admin");
        AliasResourceTest.assertEquals((String)"Alias1", (String)((String)webResource.get(String.class)));
    }

    int errorCodeFromGetting(WebResource resource) {
        try {
            resource.get(String.class);
            AliasResourceTest.fail((String)"Should have returned an error status");
            return 0;
        }
        catch (UniformInterfaceException e) {
            return e.getResponse().getStatus();
        }
    }

    public void testGetAliasForUnaliasedUserIsNotFound() {
        WebResource webResource = this.getAliasResource(APPLICATION_ID, "dir1user");
        AliasResourceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)this.errorCodeFromGetting(webResource));
    }

    public void testGetAliasForUnknownApplicationIsNotFound() {
        WebResource webResource = this.getAliasResource(MISSING_APPLICATION_ID, "dir1user");
        AliasResourceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)this.errorCodeFromGetting(webResource));
    }

    public void testSetAliasModifiesExistingAlias() {
        this.intendToModifyData();
        WebResource webResource = this.getAliasResource(APPLICATION_ID, "admin");
        webResource.put((Object)"test-modified-alias");
        AliasResourceTest.assertEquals((String)"test-modified-alias", (String)((String)webResource.get(String.class)));
    }

    public void testSetAliasAddsAlias() {
        this.intendToModifyData();
        WebResource webResource = this.getAliasResource(APPLICATION_ID, "dir1user");
        webResource.put((Object)"test-modified-alias");
        AliasResourceTest.assertEquals((String)"test-modified-alias", (String)((String)webResource.get(String.class)));
    }

    public void testDeleteRemovesAlias() {
        this.intendToModifyData();
        WebResource webResource = this.getAliasResource(APPLICATION_ID, "admin");
        webResource.delete();
        AliasResourceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)this.errorCodeFromGetting(webResource));
    }

    public void testGetUsernameByAliasReturnsOriginalUser() {
        WebResource webResource = this.getUsernameFromAliasResource(APPLICATION_ID, "Alias1");
        AliasResourceTest.assertEquals((String)"admin", (String)((String)webResource.get(String.class)));
    }

    public void testGetUsernameByAliasReturnsSameUsernameWhenNoAliasDefined() {
        WebResource webResource = this.getUsernameFromAliasResource(APPLICATION_ID, "no-user-with-this-alias");
        AliasResourceTest.assertEquals((String)"no-user-with-this-alias", (String)((String)webResource.get(String.class)));
    }

    private WebResource getAllAliasesResource(String username) {
        URI uri = this.aliasesBase().queryParam("user", new Object[]{username}).build(new Object[0]);
        return this.getWebResource("admin", "admin", uri);
    }

    public void testGetAllAliasesForUserWithoutAliasesIsEmpty() {
        AliasResourceTest.assertEquals((String)"{}", (String)((String)this.getAllAliasesResource("dir1user").get(String.class)));
    }

    public void testGetAllAliasesForUserWithAliasesIncludesApplicationsWithAliases() throws Exception {
        JsonNode obj = new ObjectMapper().readTree((String)this.getAllAliasesResource("admin").accept(new String[]{"application/json"}).get(String.class));
        AliasResourceTest.assertEquals((String)APPLICATION_ID, (String)((String)Iterators.getOnlyElement((Iterator)obj.getFieldNames())));
        AliasResourceTest.assertEquals((String)"Alias1", (String)obj.get(APPLICATION_ID).getTextValue());
    }
}

