/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.usermanagement;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.SearchRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.SearchController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.crowd.plugin.rest.service.util.CacheControl;
import com.atlassian.crowd.plugin.rest.util.EntityExpansionUtil;
import com.atlassian.crowd.plugin.rest.util.SearchRestrictionEntityTranslator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="search")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@AnonymousAllowed
public class SearchResource
extends AbstractResource {
    private static final String GROUP_ENTITY_TYPE = "group";
    private static final String USER_ENTITY_TYPE = "user";
    private final SearchController searchController;

    public SearchResource(SearchController searchController) {
        this.searchController = searchController;
    }

    @POST
    public Response search(@QueryParam(value="entity-type") String entityType, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, SearchRestrictionEntity searchRestriction) throws DirectoryNotFoundException, OperationFailedException {
        return this.search(entityType, maxResults, startIndex, SearchRestrictionEntityTranslator.toSearchRestriction(searchRestriction));
    }

    @GET
    public Response searchByCql(@QueryParam(value="entity-type") String entityType, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="") @QueryParam(value="restriction") String cqlSearchRestriction) throws DirectoryNotFoundException, OperationFailedException {
        return this.search(entityType, maxResults, startIndex, this.searchController.fromCqlSearchRestriction(cqlSearchRestriction));
    }

    private Response search(String entityType, int maxResults, int startIndex, SearchRestriction searchRestriction) {
        if (entityType == null) {
            throw new IllegalArgumentException("entity-type query parameter required.");
        }
        if (GROUP_ENTITY_TYPE.equalsIgnoreCase(entityType)) {
            boolean expandGroup = EntityExpansionUtil.shouldExpandField(GroupEntityList.class, "groups", this.request);
            boolean expandAttributes = EntityExpansionUtil.shouldExpandField(GroupEntity.class, "attributes", this.request);
            GroupEntityList groupEntityList = this.searchController.searchGroups(searchRestriction, maxResults, startIndex, expandGroup, expandAttributes, this.uriInfo.getBaseUri());
            return Response.ok((Object)groupEntityList).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (USER_ENTITY_TYPE.equalsIgnoreCase(entityType)) {
            boolean expandUser = EntityExpansionUtil.shouldExpandField(UserEntityList.class, "users", this.request);
            boolean expandAttributes = EntityExpansionUtil.shouldExpandField(UserEntity.class, "attributes", this.request);
            UserEntityList userEntityList = this.searchController.searchUsers(searchRestriction, maxResults, startIndex, expandUser, expandAttributes, this.uriInfo.getBaseUri());
            return Response.ok((Object)userEntityList).cacheControl(CacheControl.NO_CACHE).build();
        }
        throw new IllegalArgumentException("Unknown type: " + entityType);
    }
}

