/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.GroupEntityUtil;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class GroupsController
extends AbstractResourceController {
    private final ApplicationService applicationService;

    @Inject
    public GroupsController(@ComponentImport ApplicationService applicationService, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
    }

    public GroupEntity findGroupByName(String name, boolean expandAttributes, URI baseURI) throws GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        GroupEntity minimalGroup = GroupEntity.newMinimalGroupEntity(name, application.getName(), baseURI);
        return GroupEntityUtil.expandGroup(this.applicationService, application, minimalGroup, expandAttributes);
    }

    public GroupEntity addGroup(GroupEntity group, Link groupLink) throws ApplicationPermissionException, OperationFailedException, InvalidGroupException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        return GroupEntityUtil.translate(this.applicationService.addGroup(application, EntityTranslator.toGroup(group)), groupLink);
    }

    public GroupEntity updateGroup(GroupEntity group, URI baseURI) throws ApplicationPermissionException, OperationFailedException, InvalidGroupException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        Group updatedGroup = this.applicationService.updateGroup(application, EntityTranslator.toGroup(group));
        return EntityTranslator.toGroupEntity(updatedGroup, baseURI);
    }

    public void removeGroup(String groupName) throws ApplicationPermissionException, OperationFailedException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.removeGroup(application, groupName);
    }

    public void storeGroupAttributes(String groupName, MultiValuedAttributeEntityList attributes) throws ApplicationPermissionException, OperationFailedException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        if (attributes != null && !attributes.isEmpty()) {
            Map<String, Set<String>> groupAttributes = EntityTranslator.toAttributes(attributes);
            this.applicationService.storeGroupAttributes(application, groupName, groupAttributes);
        }
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws ApplicationPermissionException, OperationFailedException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.removeGroupAttributes(application, groupName, attributeName);
    }

    public UserEntityList getDirectUsers(String groupName, boolean expandUsers, int maxResults, int startIndex, URI baseUri) throws GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.verifyGroupExists(application, groupName);
        if (expandUsers) {
            MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List users = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toUserEntities(users, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List usernames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalUserEntities(usernames, baseUri);
    }

    private void verifyGroupExists(Application application, String groupName) throws GroupNotFoundException {
        this.applicationService.findGroupByName(application, groupName);
    }

    public void addDirectUser(String groupName, String username) throws ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, OperationFailedException, MembershipAlreadyExistsException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.addUserToGroup(application, username, groupName);
    }

    public UserEntity getDirectUser(String groupName, String username, URI baseUri) throws MembershipNotFoundException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.verifyGroupExists(application, groupName);
        boolean isMember = this.applicationService.isUserDirectGroupMember(application, username, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(username, groupName);
        }
        return UserEntity.newMinimalUserEntity(username, null, LinkUriHelper.buildUserLink(baseUri, username));
    }

    public void deleteDirectUser(String groupName, String username) throws ApplicationPermissionException, MembershipNotFoundException, UserNotFoundException, GroupNotFoundException, OperationFailedException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.removeUserFromGroup(application, username, groupName);
    }

    public UserEntityList getNestedUsers(String groupName, boolean expandUsers, int maxResults, int startIndex, URI baseUri) throws GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.verifyGroupExists(application, groupName);
        if (expandUsers) {
            MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List users = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toUserEntities(users, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List usernames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalUserEntities(usernames, baseUri);
    }

    public UserEntity getNestedUser(String groupName, String username, URI baseUri) throws MembershipNotFoundException, GroupNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.verifyGroupExists(application, groupName);
        boolean isMember = this.applicationService.isUserNestedGroupMember(application, username, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(username, groupName);
        }
        return UserEntity.newMinimalUserEntity(username, null, LinkUriHelper.buildUserLink(baseUri, username));
    }

    public GroupEntityList getDirectParentGroups(String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getAuthenticatedApplication();
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List groups = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List groupNames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public void addDirectParentGroup(String groupName, String parentGroupName) throws ApplicationPermissionException, InvalidMembershipException, GroupNotFoundException, OperationFailedException, MembershipAlreadyExistsException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.addGroupToGroup(application, groupName, parentGroupName);
    }

    public GroupEntity getDirectParentGroup(String groupName, String parentGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getAuthenticatedApplication();
        boolean isMember = this.applicationService.isGroupDirectGroupMember(application, groupName, parentGroupName);
        if (!isMember) {
            throw new MembershipNotFoundException(groupName, parentGroupName);
        }
        return GroupEntity.newMinimalGroupEntity(parentGroupName, null, baseUri);
    }

    public GroupEntityList getNestedParentGroups(String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getAuthenticatedApplication();
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
            List groups = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        List groupNames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public GroupEntity getNestedParentGroup(String groupName, String parentGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getAuthenticatedApplication();
        boolean isMember = this.applicationService.isGroupNestedGroupMember(application, groupName, parentGroupName);
        if (!isMember) {
            throw new MembershipNotFoundException(groupName, parentGroupName);
        }
        return GroupEntity.newMinimalGroupEntity(parentGroupName, null, baseUri);
    }

    public GroupEntityList getDirectChildGroups(String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getAuthenticatedApplication();
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
            List groups = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
        List groupNames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public void addDirectChildGroup(String groupName, String childGroupName) throws ApplicationPermissionException, InvalidMembershipException, GroupNotFoundException, OperationFailedException, MembershipAlreadyExistsException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.addGroupToGroup(application, childGroupName, groupName);
    }

    public GroupEntity getDirectChildGroup(String groupName, String childGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getAuthenticatedApplication();
        boolean isMember = this.applicationService.isGroupDirectGroupMember(application, childGroupName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(childGroupName, groupName);
        }
        return GroupEntity.newMinimalGroupEntity(childGroupName, null, baseUri);
    }

    public void deleteDirectChildGroup(String groupName, String childGroupName) throws ApplicationPermissionException, MembershipNotFoundException, GroupNotFoundException, OperationFailedException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.removeGroupFromGroup(application, childGroupName, groupName);
    }

    public GroupEntityList getNestedChildGroups(String groupName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getAuthenticatedApplication();
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
            List groups = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
        List groupNames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public GroupEntity getNestedChildGroup(String groupName, String childGroupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getAuthenticatedApplication();
        boolean isMember = this.applicationService.isGroupNestedGroupMember(application, childGroupName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(childGroupName, groupName);
        }
        return GroupEntity.newMinimalGroupEntity(childGroupName, null, baseUri);
    }
}

