/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.ImmutableMembership;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.TimedOperation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MembershipsController
extends AbstractResourceController {
    private static final Logger log = LoggerFactory.getLogger(MembershipsController.class);
    private static final EntityQuery<String> ALL_GROUPS_QUERY = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
    private final ApplicationService applicationService;
    private static final String LOG_MESSAGE = "Timed call for membership of {} for {} took {}ms. Users: {}, groups: {}";
    private static final long TIMED_LOG_THRESHOLD_MILLIS = TimeUnit.SECONDS.toMillis(1L);

    @Inject
    public MembershipsController(@ComponentImport ApplicationService applicationService, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
    }

    public StreamingOutput asXml(Iterable<? extends Membership> memberships) {
        return new OutputAsXml(memberships);
    }

    public PreparedResponse prepareQuery() {
        Application application = this.getAuthenticatedApplication();
        return new PreparedResponse(application, this.applicationService.searchGroups(application, ALL_GROUPS_QUERY));
    }

    private Iterable<Membership> getMemberships(final Application application, Iterable<String> groupNames) {
        return Iterables.transform(groupNames, (Function)new Function<String, Membership>(){

            public Membership apply(String groupName) {
                MembershipQuery userNames = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
                MembershipQuery childGroupNames = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
                long start = System.nanoTime();
                ImmutableMembership membership = new ImmutableMembership(groupName, (Iterable)MembershipsController.this.applicationService.searchDirectGroupRelationships(application, userNames), (Iterable)MembershipsController.this.applicationService.searchDirectGroupRelationships(application, childGroupNames));
                long ms = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if (ms >= TIMED_LOG_THRESHOLD_MILLIS) {
                    log.info(MembershipsController.LOG_MESSAGE, new Object[]{groupName, application.getName(), ms, membership.getUserNames().size(), membership.getChildGroupNames().size()});
                } else {
                    log.debug(MembershipsController.LOG_MESSAGE, new Object[]{groupName, application.getName(), ms, membership.getUserNames().size(), membership.getChildGroupNames().size()});
                }
                return membership;
            }
        });
    }

    void writeXmlToStream(Iterable<? extends Membership> memberships, OutputStream output) throws IOException, XMLStreamException {
        XMLStreamWriter sw = XMLOutputFactory.newInstance().createXMLStreamWriter(output, "utf-8");
        sw.writeStartDocument("utf-8", "1.0");
        sw.writeCharacters("\n");
        sw.writeStartElement("memberships");
        sw.writeCharacters("\n");
        for (Membership membership : memberships) {
            sw.writeCharacters(" ");
            sw.writeStartElement("membership");
            sw.writeAttribute("group", membership.getGroupName());
            sw.writeCharacters("\n");
            sw.writeCharacters("  ");
            sw.writeStartElement("users");
            sw.writeCharacters("\n");
            for (String user : membership.getUserNames()) {
                sw.writeCharacters("   ");
                sw.writeEmptyElement("user");
                sw.writeAttribute("name", user);
                sw.writeCharacters("\n");
            }
            sw.writeCharacters("  ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeCharacters("  ");
            sw.writeStartElement("groups");
            sw.writeCharacters("\n");
            for (String childGroup : membership.getChildGroupNames()) {
                sw.writeCharacters("   ");
                sw.writeEmptyElement("group");
                sw.writeAttribute("name", childGroup);
                sw.writeCharacters("\n");
            }
            sw.writeCharacters("  ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeCharacters(" ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
    }

    public static List<ImmutableMembership> copyOf(Iterable<? extends Membership> memberships) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(memberships, (Function)new Function<Membership, ImmutableMembership>(){

            public ImmutableMembership apply(Membership input) {
                return new ImmutableMembership(input.getGroupName(), (Iterable)input.getUserNames(), (Iterable)input.getChildGroupNames());
            }
        }));
    }

    public static String tagFor(Iterable<? extends Membership> memberships) throws NoSuchAlgorithmException {
        TreeMap<String, Membership> ms = new TreeMap<String, Membership>();
        for (Membership membership : memberships) {
            if (ms.put(membership.getGroupName(), membership) == null) continue;
            throw new IllegalArgumentException("Duplicate group name: " + membership.getGroupName());
        }
        MessageDigest md = MessageDigest.getInstance("md5");
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (Membership m : ms.values()) {
            md.update((byte)1);
            MembershipsController.addString(byteBuffer, md, m.getGroupName());
            for (String u : MembershipsController.sorted(m.getUserNames())) {
                md.update((byte)2);
                MembershipsController.addString(byteBuffer, md, u);
            }
            for (String g : MembershipsController.sorted(m.getChildGroupNames())) {
                md.update((byte)3);
                MembershipsController.addString(byteBuffer, md, g);
            }
        }
        return Base64.encodeBase64String((byte[])md.digest());
    }

    private static Iterable<String> sorted(Set<String> names) {
        return ImmutableSortedSet.copyOf(names);
    }

    private static void addString(ByteBuffer bb, MessageDigest md, String s) {
        bb.position(0);
        bb.putInt(s.length());
        bb.flip();
        md.update(bb);
        md.update(Charsets.UTF_8.encode(s));
    }

    class OutputAsXml
    implements StreamingOutput {
        private final Iterable<? extends Membership> memberships;

        public OutputAsXml(Iterable<? extends Membership> memberships) {
            this.memberships = memberships;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            TimedOperation operation = new TimedOperation();
            try {
                MembershipsController.this.writeXmlToStream(this.memberships, output);
                log.debug(operation.complete("Wrote memberships as XML"));
            }
            catch (XMLStreamException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    public class PreparedResponse {
        private final Application application;
        private final List<String> groupNames;

        PreparedResponse(Application application, List<String> groupNames) {
            this.application = application;
            this.groupNames = groupNames;
        }

        public int groupCount() {
            return this.groupNames.size();
        }

        public StreamingOutput stream() {
            return MembershipsController.this.asXml(MembershipsController.this.getMemberships(this.application, this.groupNames));
        }

        public Iterable<ImmutableMembership> getMemberships() {
            return MembershipsController.copyOf(MembershipsController.this.getMemberships(this.application, this.groupNames));
        }
    }
}

