/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.usermanagement;

import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.service.controller.AuthenticationController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="authentication")
@AnonymousAllowed
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class AuthenticationResource
extends AbstractResource {
    private final AuthenticationController authenticationController;

    public AuthenticationResource(AuthenticationController authenticationController) {
        this.authenticationController = authenticationController;
    }

    @POST
    public Response authenticateUser(@QueryParam(value="username") String username, PasswordEntity password) throws ApplicationAccessDeniedException, ExpiredCredentialException, InactiveAccountException, InvalidAuthenticationException, OperationFailedException {
        try {
            UserEntity userEntity = this.authenticationController.authenticateUser(username, password, this.uriInfo.getBaseUri());
            return Response.ok((Object)userEntity).build();
        }
        catch (UserNotFoundException e) {
            ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
    }
}

