/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AuthenticationController
extends AbstractResourceController {
    private final ApplicationService applicationService;

    @Inject
    public AuthenticationController(@ComponentImport ApplicationService applicationService, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
    }

    public UserEntity authenticateUser(String username, PasswordEntity password, URI baseUri) throws UserNotFoundException, ExpiredCredentialException, InactiveAccountException, InvalidAuthenticationException, OperationFailedException {
        User user;
        Application application = this.getAuthenticatedApplication();
        if (!this.applicationService.isUserAuthorised(application, user = this.applicationService.authenticateUser(application, username, PasswordCredential.unencrypted((String)password.getValue())))) {
            throw new InvalidAuthenticationException("User is not allowed to authenticate with the application");
        }
        Link userLink = LinkUriHelper.buildUserLink(baseUri, user.getName());
        UserEntity userEntity = EntityTranslator.toUserEntity(user, userLink);
        return userEntity;
    }
}

