/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.usermanagement;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.TokenExpiredException;
import com.atlassian.crowd.exception.TokenNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.plugin.rest.entity.AuthenticationContextEntity;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.SessionEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.TokenController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

@Path(value="session")
@AnonymousAllowed
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class TokenResource
extends AbstractResource {
    public static final String TOKEN_CACHE_CONTROL_MAX_AGE_SYSTEM_PROPERTY = "crowd.token.http.cache-control.max-age";
    private final Optional<CacheControl> tokenCacheControl;
    private final TokenController tokenController;

    public TokenResource(TokenController tokenController) {
        this.tokenController = tokenController;
        String maxAgeAsString = System.getProperty(TOKEN_CACHE_CONTROL_MAX_AGE_SYSTEM_PROPERTY, "-1");
        this.tokenCacheControl = TokenResource.parseTokenCacheControl(maxAgeAsString);
    }

    private static Optional<CacheControl> parseTokenCacheControl(String maxAgeAsString) {
        int maxAge;
        try {
            maxAge = Integer.parseInt(maxAgeAsString);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        if (maxAge < 0) {
            return Optional.empty();
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge(maxAge);
        return Optional.of(cacheControl);
    }

    @POST
    public Response authenticateUser(AuthenticationContextEntity authenticationContext, @DefaultValue(value="true") @QueryParam(value="validate-password") boolean validatePassword, @DefaultValue(value="-1") @QueryParam(value="duration") long durationInSeconds) throws InvalidAuthenticationException, InactiveAccountException, ExpiredCredentialException, ApplicationAccessDeniedException, OperationFailedException {
        String applicationName = this.getApplicationName();
        String username = authenticationContext.getUserName();
        String password = authenticationContext.getPassword();
        List<ValidationFactorEntity> validationFactors = authenticationContext.getValidationFactors();
        TokenLifetime tokenLifetime = durationInSeconds < 0L ? TokenLifetime.USE_DEFAULT : TokenLifetime.inSeconds((long)durationInSeconds);
        SessionEntity session = validatePassword ? this.tokenController.authenticateUser(applicationName, username, password, tokenLifetime, validationFactors, this.getBaseUri()) : this.tokenController.authenticateUserWithoutValidatingPassword(applicationName, username, validationFactors, this.getBaseUri());
        return Response.created((URI)LinkUriHelper.buildSessionUri(this.getBaseUri(), session.getToken())).entity((Object)session).cacheControl(com.atlassian.crowd.plugin.rest.service.util.CacheControl.NO_CACHE).build();
    }

    @DELETE
    @Path(value="{token}")
    public Response invalidateToken(@PathParam(value="token") String token) {
        this.tokenController.invalidateToken(token);
        return Response.noContent().build();
    }

    @POST
    @Path(value="{token}")
    public Response validateToken(@PathParam(value="token") String token, ValidationFactorEntityList validationFactors) throws InvalidTokenException, ApplicationAccessDeniedException, OperationFailedException {
        String applicationName = this.getApplicationName();
        List<ValidationFactorEntity> factors = validationFactors.getValidationFactors();
        try {
            SessionEntity session = this.tokenController.validateToken(applicationName, token, factors, this.getBaseUri());
            Response.ResponseBuilder responseBuilder = Response.ok((Object)session);
            if (this.tokenCacheControl.isPresent()) {
                responseBuilder.cacheControl(this.tokenCacheControl.get());
            }
            return responseBuilder.build();
        }
        catch (TokenNotFoundException e) {
            ErrorEntity error = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
        }
        catch (TokenExpiredException e) {
            ErrorEntity error = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build();
        }
    }

    @GET
    @Path(value="{token}")
    public Response getSession(@PathParam(value="token") String token) throws InvalidTokenException, OperationFailedException, ApplicationAccessDeniedException {
        String applicationName = this.getApplicationName();
        SessionEntity session = this.tokenController.getSessionFromToken(token, applicationName, this.getBaseUri());
        Response.ResponseBuilder responseBuilder = Response.ok((Object)session);
        if (this.tokenCacheControl.isPresent()) {
            responseBuilder.cacheControl(this.tokenCacheControl.get());
        }
        return responseBuilder.build();
    }

    @DELETE
    public Response deleteTokensForUser(@QueryParam(value="username") String username, @QueryParam(value="exclude") String exclusionToken) {
        if (username != null) {
            try {
                this.tokenController.invalidateTokensForUser(username, exclusionToken, this.getApplicationName());
            }
            catch (UserNotFoundException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
            }
            catch (ApplicationNotFoundException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        } else {
            this.tokenController.invalidateAllTokens();
        }
        return Response.noContent().build();
    }
}

