/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.plugin.rest.filter.BasicAuthenticationHelper;
import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicApplicationAuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(BasicApplicationAuthenticationFilter.class);
    private static final String CHALLENGE_MSG = "Application failed to authenticate";
    private static final String BASIC_AUTH_REALM = "Crowd REST Service";
    private static final TokenLifetime APPLICATION_TOKEN_LIFETIME = TokenLifetime.inSeconds((long)60L);
    private final ApplicationManager applicationManager;
    private final ClientValidationManager clientValidationManager;
    private final TokenAuthenticationManager tokenAuthenticationManager;

    public BasicApplicationAuthenticationFilter(ApplicationManager applicationManager, ClientValidationManager clientValidationManager, TokenAuthenticationManager tokenAuthenticationManager) {
        this.applicationManager = applicationManager;
        this.clientValidationManager = clientValidationManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        BasicAuthenticationHelper.Credentials credentials = BasicAuthenticationHelper.getBasicAuthCredentials(request);
        if (credentials == null) {
            LOG.debug("No basic auth credentials found in request, responding with authentication challenge");
            BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
        } else {
            try {
                Application application = this.applicationManager.findByName(credentials.getName());
                this.clientValidationManager.validate(application, request);
                if (this.isAuthenticated(request, credentials)) {
                    LOG.debug("Application '{}' is already authenticated", (Object)credentials.getName());
                    chain.doFilter((ServletRequest)request, servletResponse);
                } else {
                    Token token = this.authenticate(application, credentials.getPassword());
                    LOG.debug("Application '{}' authenticated successfully", (Object)credentials.getName());
                    AuthenticatedApplicationUtil.setAuthenticatedApplication(request, credentials.getName());
                    if (token != null) {
                        AuthenticatedApplicationUtil.setAuthenticatedApplicationToken(request, token);
                    }
                    chain.doFilter((ServletRequest)request, servletResponse);
                }
            }
            catch (ApplicationNotFoundException e) {
                LOG.info("Application '{}' failed authentication", (Object)credentials.getName());
                BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
            }
            catch (InvalidAuthenticationException e) {
                LOG.info("Invalid authentication for application with name '{}'", (Object)credentials.getName());
                BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
            }
            catch (ClientValidationException e) {
                response.sendError(403, e.getMessage());
            }
        }
    }

    public void destroy() {
    }

    @Nullable
    private Token authenticate(Application application, String password) throws ClientValidationException, InvalidAuthenticationException, ApplicationNotFoundException {
        ApplicationAuthenticationContext authenticationContext = new ApplicationAuthenticationContext(application.getName(), PasswordCredential.unencrypted((String)password), new ValidationFactor[0]);
        Token token = this.tokenAuthenticationManager.authenticateApplication(authenticationContext, APPLICATION_TOKEN_LIFETIME);
        if (token == null && !this.applicationManager.authenticate(application, PasswordCredential.unencrypted((String)password))) {
            throw InvalidAuthenticationException.newInstanceWithName((String)application.getName());
        }
        return token;
    }

    private boolean isAuthenticated(HttpServletRequest request, BasicAuthenticationHelper.Credentials credentials) {
        Token token = AuthenticatedApplicationUtil.getAuthenticatedApplicationToken(request);
        if (token != null) {
            try {
                this.tokenAuthenticationManager.validateApplicationToken(token.getRandomHash(), new ValidationFactor[0]);
            }
            catch (InvalidTokenException e) {
                return false;
            }
        }
        return credentials.getName().equals(AuthenticatedApplicationUtil.getAuthenticatedApplication(request));
    }
}

