package com.atlassian.crowd.plugin.rest.response;


import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import java.net.URI;

public class ResponseFactory {

    private ResponseFactory() {
    }

    /**
     * Provides a cacheControl with noStore and noCache set to true
     */
    private static final CacheControl NO_CACHE = new CacheControl();

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }

    public static CacheControl never() {
        return NO_CACHE;
    }

    private static Response.ResponseBuilder applyDefaults(Response.ResponseBuilder builder) {
        return builder
                .cacheControl(never())
                // Regardless of the cache policy specify the correct VARY headers
                .header(HttpHeaders.VARY, "X-AUSERNAME") // Chrome Dev Channel doesn't properly support Vary Cookie so this is here for good measure
                .header(HttpHeaders.VARY, "Cookie"); // This is here incase plugins don't send the X-AUSERNAME header in the request.
    }

    public static Response.ResponseBuilder ok() {
        return applyDefaults(Response.ok());
    }

    public static Response.ResponseBuilder ok(Object entity) {
        return applyDefaults(Response.ok(entity));
    }

    public static Response.ResponseBuilder ok(Object entity, CacheControl cacheControl) {
        return applyDefaults(Response.ok(entity)).cacheControl(cacheControl);
    }

    public static Response.ResponseBuilder created(URI location) {
        return applyDefaults(Response.created(location));
    }

    public static Response.ResponseBuilder noContent() {
        return applyDefaults(Response.noContent());
    }

    public static Response.ResponseBuilder status(Response.Status status) {
        return applyDefaults(Response.status(status));
    }

    public static Response.ResponseBuilder serverError() {
        return applyDefaults(Response.serverError());
    }
}