package com.atlassian.crowd.plugin.rest.provider;

import com.google.common.collect.ImmutableList;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;

import java.util.Collections;
import java.util.List;

import static com.atlassian.crowd.common.properties.SystemProperties.INCLUDE_USERNAME_HEADER_IN_RESPONSES;

public class RestUsernameHeaderFilterFactory implements ResourceFilterFactory {
    @Override
    public List<ResourceFilter> create(AbstractMethod abstractMethod) {
        if (INCLUDE_USERNAME_HEADER_IN_RESPONSES.getValue()) {
            return ImmutableList.of(new RestUsernameHeaderFilter());
        }

        return Collections.emptyList();
    }
}
