package com.atlassian.crowd.plugin.rest.filter;

import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;

/**
 * A {@link javax.servlet.Filter} that disables all Seraph processing further along the chain.
 */
@Named
public class SeraphDisablerFilter implements Filter {
    private static final String DISABLE_SECURITY_FILTER_FLAG = "os_securityfilter_already_filtered";
    private static final String DISABLE_LOGIN_FILTER_FLAG = "loginfilter.already.filtered";

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
        // do nothing
    }

    @Override
    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain)
            throws IOException, ServletException {
        servletRequest.setAttribute(DISABLE_SECURITY_FILTER_FLAG, Boolean.TRUE);
        servletRequest.setAttribute(DISABLE_LOGIN_FILTER_FLAG, Boolean.TRUE);

        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {
        // do nothing
    }
}
