package com.atlassian.crowd.plugin.rest.filter;

import java.io.IOException;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.binary.Base64;

/**
 * A collection of methods that help implementing HTTP basic auth for end users and applications.
 */
public final class BasicAuthenticationHelper {
    private BasicAuthenticationHelper() {
        // I'm a helper class. Use my methods, but do not instantiate me.
    }

    /**
     * Returns the Basic Auth credentials.
     *
     * @param request the request
     * @return basic authentication credentials
     */
    public static Credentials getBasicAuthCredentials(final HttpServletRequest request) {
        Credentials credentials = null;

        String header = request.getHeader("Authorization");

        if (header != null && header.substring(0, 5).equalsIgnoreCase("Basic")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64(base64Token.getBytes()));

            final int delim = token.indexOf(":");

            if (delim != -1) {
                String name = token.substring(0, delim);
                String password = token.substring(delim + 1);

                credentials = new Credentials(name, password);
            }
        }

        return credentials;
    }

    /**
     * Responds to request with a message and a Basic Authentication challenge.
     *
     * @param response       the HTTP response
     * @param message        plain text message to send
     * @param basicAuthRealm used as the realm for the WWWW-Authenticate header
     */
    public static void respondWithChallenge(final HttpServletResponse response, String message, String basicAuthRealm)
            throws IOException {
        response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
        response.setHeader("WWW-Authenticate", "BASIC realm=\"" + basicAuthRealm + "\"");
        response.setHeader("Content-Type", "text/plain;charset=UTF-8");
        response.getWriter().print(message);
        response.flushBuffer();
    }

    public static class Credentials {
        private final String name;
        private final String password;

        private Credentials(final String name, final String password) {
            this.name = name;
            this.password = password;
        }

        public String getName() {
            return name;
        }

        public String getPassword() {
            return password;
        }
    }
}
