package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.plugin.rest.exception.entity.ValidationErrorsEntity;
import com.atlassian.crowd.plugin.rest.exception.ValidationFailedException;
import com.atlassian.crowd.validator.ValidationError;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import java.util.List;

@Provider
public class ValidationFailedExceptionMapper implements ExceptionMapper<ValidationFailedException> {
    @Override
    public Response toResponse(ValidationFailedException e) {
        final List<ValidationError> errorMessages = e.getErrorMessages();
        final ValidationErrorsEntity responseEntity = new ValidationErrorsEntity(errorMessages);
        return Response.status(Response.Status.BAD_REQUEST).entity(responseEntity).build();
    }
}
