package com.atlassian.crowd.plugin.rest.exception.mapper;


import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.atlassian.crowd.manager.permission.UserPermissionException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;

@Provider
public class UserPermissionExceptionMapper implements ExceptionMapper<UserPermissionException> {
    @Override
    public Response toResponse(UserPermissionException e) {
        return Response.status(Response.Status.UNAUTHORIZED).entity(ErrorEntity.of(e)).build();
    }
}
