package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.emailchange.SameEmailAddressException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class SameEmailAddressExceptionMapper implements ExceptionMapper<SameEmailAddressException> {
    @Override
    public Response toResponse(SameEmailAddressException e) {
        return Response.status(Response.Status.BAD_REQUEST).entity(ErrorEntity.of(e)).build();
    }
}
