package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.manager.sso.InvalidApplicationSamlConfigurationException;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class InvalidApplicationSamlConfigurationExceptionMapper implements ExceptionMapper<InvalidApplicationSamlConfigurationException> {
    @Override
    public Response toResponse(InvalidApplicationSamlConfigurationException exception) {
        return Response.status(Response.Status.BAD_REQUEST)
                .entity(exception.getErrors())
                .build();
    }
}
