package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.exception.FeatureDisabledException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.sun.jersey.api.client.ClientResponse;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class FeatureDisabledExceptionMapper implements ExceptionMapper<FeatureDisabledException> {
    @Override
    public Response toResponse(FeatureDisabledException e) {
        return Response.status(ClientResponse.Status.PRECONDITION_FAILED).entity(ErrorEntity.of(e)).build();
    }
}
