package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.atlassian.sal.api.message.I18nResolver;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import static com.google.common.base.Preconditions.checkNotNull;

@Provider
public class AuthenticationRequiredExceptionMapper implements ExceptionMapper<AuthenticationRequiredException>{

    private I18nResolver i18nResolver;

    public AuthenticationRequiredExceptionMapper(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = checkNotNull(i18nResolver);
    }

    @Override
    public Response toResponse(AuthenticationRequiredException e) {
        String message = i18nResolver.getText("crowd.administrators.anonymous.exception");
        final ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), message);
        return Response.status(Response.Status.UNAUTHORIZED).entity(errorEntity).build();
    }
}
