package com.atlassian.crowd.plugin.rest.exception.mapper;


import com.atlassian.crowd.manager.permission.AnonymousUserPermissionException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import static com.google.common.base.Preconditions.checkNotNull;

@Provider
public class AnonymousUserPermissionExceptionMapper implements ExceptionMapper<AnonymousUserPermissionException> {
    private I18nResolver i18nResolver;

    public AnonymousUserPermissionExceptionMapper(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = checkNotNull(i18nResolver);
    }

    @Override
    public Response toResponse(AnonymousUserPermissionException e) {
        String message = i18nResolver.getText("crowd.administrators.anonymous.exception");
        final ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), message);
        return Response.status(Response.Status.UNAUTHORIZED).entity(errorEntity).build();
    }
}
