package com.atlassian.crowd.plugin.rest.exception.entity;

import com.atlassian.crowd.validator.ValidationError;
import com.google.common.collect.ImmutableList;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidationErrorsEntity {

    public static class ErrorMessage {

        @JsonProperty("field")
        private String field;

        @JsonProperty("messages")
        private List<String> messages;

        public ErrorMessage(String field, List<String> messages) {
            this.field = field;
            this.messages = messages;
        }

        public String getField() {
            return field;
        }

        public List<String> getMessages() {
            return messages;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ErrorMessage that = (ErrorMessage) o;
            return Objects.equals(field, that.field) &&
                    Objects.equals(messages, that.messages);
        }

        @Override
        public int hashCode() {
            return Objects.hash(field, messages);
        }
    }

    @JsonProperty(value = "errors")
    private final List<ErrorMessage> errors = new ArrayList<>();

    public ValidationErrorsEntity(List<ValidationError> validationErrors) {
        Map<String, List<String>> fieldMessageMap = validationErrors.stream()
                .collect(Collectors.toMap(ValidationError::getFieldName,
                        v -> Collections.singletonList(v.getErrorMessage()),
                        (firstList, secondList) -> ImmutableList.<String>builder()
                                .addAll(firstList).addAll(secondList).build(), LinkedHashMap::new));

        fieldMessageMap.forEach((key, values) -> errors.add(new ErrorMessage(key, values)));
    }

    public List<ErrorMessage> getErrors() {
        return Collections.unmodifiableList(errors);
    }
}
