package com.atlassian.crowd.plugin.rest.entity.admin.user;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class UserSearchParams {
    @JsonProperty("search")
    private final String search;
    @JsonProperty("directoryIds")
    @Nullable
    private final List<Long> directoryIds;
    @JsonProperty("active")
    private final Boolean active;
    @JsonProperty("avatarSizeHint")
    private final int avatarSizeHint;

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public UserSearchParams(@JsonProperty("search") String search, @JsonProperty("directoryIds") List<Long> directoryIds,
                            @JsonProperty("active") Boolean active, @JsonProperty("avatarSizeHint") int avatarSizeHint) {
        this.search = search;
        this.directoryIds = directoryIds != null ? ImmutableList.copyOf(directoryIds) : null;
        this.active = active;
        this.avatarSizeHint = avatarSizeHint;
    }

    public String getSearch() {
        return search;
    }

    public List<Long> getDirectoryIds() {
        return directoryIds;
    }

    public Boolean getActive() {
        return active;
    }

    public int getAvatarSizeHint() {
        return avatarSizeHint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserSearchParams that = (UserSearchParams) o;

        return Objects.equals(this.getSearch(), that.getSearch()) &&
                Objects.equals(this.getDirectoryIds(), that.getDirectoryIds()) &&
                Objects.equals(this.getActive(), that.getActive()) &&
                Objects.equals(this.getAvatarSizeHint(), that.getAvatarSizeHint());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getSearch(), getDirectoryIds(), getActive(), getAvatarSizeHint());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("search", getSearch())
                .add("directoryIds", getDirectoryIds())
                .add("active", getActive())
                .add("avatarSizeHint", getAvatarSizeHint())
                .toString();
    }
}
