package com.atlassian.crowd.plugin.rest.entity.admin.group;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryData;
import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryEntityId;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class GroupData {
    @JsonProperty("id")
    private final DirectoryEntityId id;
    @JsonProperty("displayName")
    private final String displayName;
    @JsonProperty("description")
    private final String description;
    @JsonProperty("directory")
    private final DirectoryData directory;

    public static GroupData fromGroup(Group group, Directory directoryById) {
        return GroupData.builder()
                .setId(DirectoryEntityId.fromGroup(group))
                .setDisplayName(group.getName())
                .setDescription(group.getDescription())
                .setDirectory(DirectoryData.fromDirectory(directoryById))
                .build();
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    @JsonCreator
    public GroupData(@JsonProperty("id") DirectoryEntityId id, @JsonProperty("displayName") String displayName, @JsonProperty("description") String description, @JsonProperty("directory") DirectoryData directory) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.directory = directory;
    }

    public DirectoryEntityId getId() {
        return id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getDescription() {
        return description;
    }

    public DirectoryData getDirectory() {
        return directory;
    }

    public static GroupData.Builder builder() {
        return new GroupData.Builder();
    }

    public static GroupData.Builder builder(GroupData data) {
        return new GroupData.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        GroupData that = (GroupData) o;

        return Objects.equals(this.getId(), that.getId()) &&
                Objects.equals(this.getDisplayName(), that.getDisplayName()) &&
                Objects.equals(this.getDescription(), that.getDescription()) &&
                Objects.equals(this.getDirectory(), that.getDirectory());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getDisplayName(), getDescription(), getDirectory());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("displayName", getDisplayName())
                .add("description", getDescription())
                .add("directory", getDirectory())
                .toString();
    }

    public static final class Builder {

        private DirectoryEntityId id;
        private String displayName;
        private String description;
        private DirectoryData directory;

        private Builder() {
        }

        private Builder(GroupData initialData) {

            this.id = initialData.getId();
            this.displayName = initialData.getDisplayName();
            this.description = initialData.getDescription();
            this.directory = initialData.getDirectory();
        }


        public Builder setId(DirectoryEntityId id) {
            this.id = id;
            return this;
        }


        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }


        public Builder setDirectory(DirectoryData directory) {
            this.directory = directory;
            return this;
        }


        public GroupData build() {
            return new GroupData(id, displayName, description, directory);
        }
    }
}
