package com.atlassian.crowd.plugin.rest.entity.admin.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

public class DirectoryData {
    @JsonProperty("id")
    private final long id;
    @JsonProperty("displayName")
    private final String displayName;
    @JsonProperty("directoryType")
    private final DirectoryType directoryType;

    public static DirectoryData fromDirectory(Directory directory) {
        return new DirectoryData(directory.getId(), directory.getName(), directory.getType());
    }

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    @JsonCreator
    public DirectoryData(@JsonProperty("id") long id, @JsonProperty("displayName") String displayName, @JsonProperty("directoryType") DirectoryType directoryType) {
        this.id = id;
        this.displayName = displayName;
        this.directoryType = directoryType;
    }

    public long getId() {
        return id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public DirectoryType getDirectoryType() {
        return directoryType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DirectoryData that = (DirectoryData) o;

        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDirectoryType(), that.getDirectoryType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getDisplayName(), getDirectoryType());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("displayName", getDisplayName())
                .add("directoryType", getDirectoryType())
                .toString();
    }
}
