package com.atlassian.crowd.plugin.rest.entity.admin;

import com.atlassian.crowd.plugin.rest.entity.admin.directory.DirectoryEntityId;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class GroupSearchResultEntity {
    @JsonProperty("id")
    private DirectoryEntityId id;

    @JsonProperty("active")
    private Boolean active;

    @JsonProperty("name")
    private String name;

    @JsonProperty("description")
    private String description;

    protected GroupSearchResultEntity() {
    }

    public GroupSearchResultEntity(String name, String description, long directoryId, boolean active) {
        this.name = name;
        this.description = description;
        this.id = new DirectoryEntityId(directoryId, name);
        this.active = active;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupSearchResultEntity that = (GroupSearchResultEntity) o;
        return id.equals(that.id) &&
                active.equals(that.active) &&
                name.equals(that.name) &&
                description.equals(that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, active, name, description);
    }
}
