package com.atlassian.crowd.plugin.rest.entity.admin;

import com.atlassian.plugins.rest.common.expand.Expandable;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.List;
import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class DirectoryMappingEntity {
    @JsonProperty("id")
    private Long id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("authentication")
    @Expandable("authentication")
    private DirectoryMappingAuthenticationEntity authentication;

    @JsonProperty("defaultGroups")
    @Expandable("defaultGroups")
    private List<String> defaultGroups;

    protected DirectoryMappingEntity() {
    }

    public DirectoryMappingEntity(Long id, String name, DirectoryMappingAuthenticationEntity authentication, List<String> defaultGroups) {
        this.id = id;
        this.name = name;
        this.authentication = authentication;
        this.defaultGroups = defaultGroups;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public DirectoryMappingAuthenticationEntity getAuthentication() {
        return authentication;
    }

    public List<String> getDefaultGroups() {
        return defaultGroups;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("name", name)
                .add("authentication", authentication)
                .add("defaultGroups", defaultGroups)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DirectoryMappingEntity that = (DirectoryMappingEntity) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                Objects.equals(authentication, that.authentication) &&
                Objects.equals(defaultGroups, that.defaultGroups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, authentication, defaultGroups);
    }
}