package com.atlassian.crowd.plugin.rest.entity.admin;

import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class BatchResultWithFailureReasonsRestDto<T> {
    @JsonProperty("successes")
    private final Collection<T> successes;
    @JsonProperty("failures")
    private final Collection<FailedEntity<T>> failures;

    public BatchResultWithFailureReasonsRestDto() {
        this.successes = new ArrayList<>();
        this.failures = new ArrayList<>();
    }

    @JsonCreator
    public BatchResultWithFailureReasonsRestDto(@JsonProperty("successes") Collection<T> successes, @JsonProperty("failures") Collection<FailedEntity<T>> failures) {
        this.successes = successes;
        this.failures = failures;
    }

    public void addSuccess(T entityName) {
        successes.add(entityName);
    }

    public void addAllSuccesses(Collection<T> successes) {
        this.successes.addAll(successes);
    }

    public void addFailedEntity(T entityName, String reason) {
        failures.add(new FailedEntity<>(entityName, reason));
    }

    public void addAllFailedEntities(Collection<FailedEntity<T>> failures) {
        this.failures.addAll(failures);
    }

    public Collection<FailedEntity<T>> getFailures() {
        return failures;
    }

    public Collection<T> getSuccesses() {
        return successes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BatchResultWithFailureReasonsRestDto that = (BatchResultWithFailureReasonsRestDto) o;
        return Objects.equals(successes, that.successes) &&
                Objects.equals(failures, that.failures);
    }

    @Override
    public int hashCode() {
        return Objects.hash(successes, failures);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("successes", successes)
                .add("failures", failures)
                .toString();
    }
}
