package com.atlassian.crowd.plugin.rest.entity.admin;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.plugins.rest.common.expand.Expandable;
import com.google.common.base.MoreObjects;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class ApplicationEntity {
    @JsonProperty("id")
    private Long id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("description")
    private String description;

    @JsonProperty("type")
    private ApplicationType type;

    @JsonProperty("active")
    private Boolean active;

    @JsonProperty("aliasingEnabled")
    private Boolean aliasingEnabled;

    @JsonProperty("lowercaseOutput")
    private Boolean lowercaseOutput;

    @JsonProperty("aggregateMemberships")
    private Boolean aggregateMemberships;

    @JsonProperty("cachedDirectoriesAuthenticationOrderOptimisation")
    private Boolean cachedDirectoriesAuthenticationOrderOptimisation;

    @Expandable("directoryMappings")
    @JsonProperty("directoryMappings")
    private DirectoryMappingsEntity directoryMappings;

    @JsonProperty("filteringUsersWithAccessEnabled")
    private Boolean filteringUsersWithAccessEnabled;

    @JsonProperty("filteringGroupsWithAccessEnabled")
    private Boolean filteringGroupsWithAccessEnabled;

    protected ApplicationEntity() {
    }

    public ApplicationEntity(Long id, String name, String description, ApplicationType type, Boolean active,
                             Boolean aliasingEnabled, Boolean lowercaseOutput, Boolean aggregateMemberships,
                             Boolean cachedDirectoriesAuthenticationOrderOptimisation) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.active = active;
        this.aliasingEnabled = aliasingEnabled;
        this.lowercaseOutput = lowercaseOutput;
        this.aggregateMemberships = aggregateMemberships;
        this.cachedDirectoriesAuthenticationOrderOptimisation = cachedDirectoriesAuthenticationOrderOptimisation;
        this.filteringUsersWithAccessEnabled = null;
        this.filteringGroupsWithAccessEnabled = null;
    }

    public ApplicationEntity(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.active = builder.active;
        this.aliasingEnabled = builder.aliasingEnabled;
        this.lowercaseOutput = builder.lowercaseOutput;
        this.aggregateMemberships = builder.aggregateMemberships;
        this.cachedDirectoriesAuthenticationOrderOptimisation = builder.cachedDirectoriesAuthenticationOrderOptimisation;
        this.filteringUsersWithAccessEnabled = builder.filteringUsersWithAccessEnabled;
        this.filteringGroupsWithAccessEnabled = builder.filteringGroupsWithAccessEnabled;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public ApplicationType getType() {
        return type;
    }

    public Boolean getActive() {
        return active;
    }

    public Boolean getAliasingEnabled() {
        return aliasingEnabled;
    }

    public Boolean getLowercaseOutput() {
        return lowercaseOutput;
    }

    public Boolean getAggregateMemberships() {
        return aggregateMemberships;
    }

    public Boolean getCachedDirectoriesAuthenticationOrderOptimisation() {
        return cachedDirectoriesAuthenticationOrderOptimisation;
    }

    public Boolean getFilteringUsersWithAccessEnabled() {
        return filteringUsersWithAccessEnabled;
    }

    public Boolean getFilteringGroupsWithAccessEnabled() {
        return filteringGroupsWithAccessEnabled;
    }

    public DirectoryMappingsEntity getDirectoryMappings() {
        return directoryMappings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationEntity that = (ApplicationEntity) o;
        return Objects.equals(id, that.id)
                && Objects.equals(name, that.name)
                && Objects.equals(description, that.description)
                && type == that.type
                && Objects.equals(active, that.active)
                && Objects.equals(aliasingEnabled, that.aliasingEnabled)
                && Objects.equals(lowercaseOutput, that.lowercaseOutput)
                && Objects.equals(aggregateMemberships, that.aggregateMemberships)
                && Objects.equals(cachedDirectoriesAuthenticationOrderOptimisation, that.cachedDirectoriesAuthenticationOrderOptimisation)
                && Objects.equals(directoryMappings, that.directoryMappings)
                && Objects.equals(filteringUsersWithAccessEnabled, that.filteringUsersWithAccessEnabled)
                && Objects.equals(filteringGroupsWithAccessEnabled, that.filteringGroupsWithAccessEnabled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, description, type, active, aliasingEnabled, lowercaseOutput,
                aggregateMemberships, cachedDirectoriesAuthenticationOrderOptimisation, directoryMappings,
                filteringUsersWithAccessEnabled, filteringGroupsWithAccessEnabled);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("name", name)
                .add("description", description)
                .add("type", type)
                .add("active", active)
                .add("aliasingEnabled", aliasingEnabled)
                .add("lowercaseOutput", lowercaseOutput)
                .add("aggregateMemberships", aggregateMemberships)
                .add("cachedDirectoriesAuthenticationOrderOptimisation", cachedDirectoriesAuthenticationOrderOptimisation)
                .add("directoryMappings", directoryMappings)
                .add("filteringUsersWithAccessEnabled", filteringUsersWithAccessEnabled)
                .add("filteringGroupsWithAccessEnabled", filteringGroupsWithAccessEnabled)
                .toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationEntity applicationEntity) {
        return new Builder(applicationEntity);
    }

    public static final class Builder {

        private Long id;
        private String name;
        private String description;
        private ApplicationType type;
        private Boolean active;
        private Boolean aliasingEnabled;
        private Boolean lowercaseOutput;
        private Boolean aggregateMemberships;
        private Boolean cachedDirectoriesAuthenticationOrderOptimisation;
        private Boolean filteringUsersWithAccessEnabled;
        private Boolean filteringGroupsWithAccessEnabled;
        private DirectoryMappingsEntity directoryMappings;

        private Builder() {
        }

        private Builder(ApplicationEntity initialData) {
            this.id = initialData.getId();
            this.name = initialData.getName();
            this.description = initialData.getDescription();
            this.type = initialData.getType();
            this.active = initialData.getActive();
            this.aliasingEnabled = initialData.getAliasingEnabled();
            this.lowercaseOutput = initialData.getLowercaseOutput();
            this.aggregateMemberships = initialData.getAggregateMemberships();
            this.cachedDirectoriesAuthenticationOrderOptimisation = initialData.getCachedDirectoriesAuthenticationOrderOptimisation();
            this.filteringUsersWithAccessEnabled = initialData.getFilteringUsersWithAccessEnabled();
            this.filteringGroupsWithAccessEnabled = initialData.getFilteringGroupsWithAccessEnabled();
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setType(ApplicationType type) {
            this.type = type;
            return this;
        }

        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder setAliasingEnabled(Boolean aliasingEnabled) {
            this.aliasingEnabled = aliasingEnabled;
            return this;
        }

        public Builder setLowercaseOutput(Boolean lowercaseOutput) {
            this.lowercaseOutput = lowercaseOutput;
            return this;
        }

        public Builder setAggregateMemberships(Boolean aggregateMemberships) {
            this.aggregateMemberships = aggregateMemberships;
            return this;
        }

        public Builder setFilteringUsersWithAccessEnabled(Boolean filteringUsersWithAccessEnabled) {
            this.filteringUsersWithAccessEnabled = filteringUsersWithAccessEnabled;
            return this;
        }
        
        public Builder setFilteringGroupsWithAccessEnabled(Boolean filteringGroupsWithAccessEnabled) {
            this.filteringGroupsWithAccessEnabled = filteringGroupsWithAccessEnabled;
            return this;
        }

        public Builder setCachedDirectoriesAuthenticationOrderOptimisation(Boolean cachedDirectoriesAuthenticationOrderOptimisation) {
            this.cachedDirectoriesAuthenticationOrderOptimisation = cachedDirectoriesAuthenticationOrderOptimisation;
            return this;
        }

        public Builder setDirectoryMappings(DirectoryMappingsEntity directoryMappings) {
            this.directoryMappings = directoryMappings;
            return this;
        }

        public ApplicationEntity build() {
            return new ApplicationEntity(this);
        }
    }
}