package com.atlassian.crowd.plugin.rest.entity.admin;

import com.atlassian.crowd.model.application.AccessBasedSynchronizationFilterType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public class AccessBasedSynchronizationFilterTypeEntity {
    @JsonProperty("filterType")
    private AccessBasedSynchronizationFilterType filterType;

    protected AccessBasedSynchronizationFilterTypeEntity() {
    }

    public AccessBasedSynchronizationFilterTypeEntity(AccessBasedSynchronizationFilterType filterType) {
        this.filterType = Preconditions.checkNotNull(filterType);
    }

    public AccessBasedSynchronizationFilterType getFilterType() {
        return filterType;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("filterType", filterType)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccessBasedSynchronizationFilterTypeEntity that = (AccessBasedSynchronizationFilterTypeEntity) o;
        return Objects.equals(filterType, that.filterType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(filterType);
    }
}