package com.atlassian.crowd.plugin.rest.util;

import java.lang.reflect.InvocationTargetException;

import com.atlassian.crowd.manager.permission.UserPermissionException;
import com.atlassian.crowd.manager.permission.UserPermissionService;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;

public class SysAdminInterceptor implements ResourceInterceptor {
    private final UserPermissionService userPermissionService;

    public SysAdminInterceptor(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }

    @Override
    public void intercept(MethodInvocation methodInvocation) throws IllegalAccessException, InvocationTargetException {
        if (userPermissionService.currentUserHasPermission(UserPermission.SYS_ADMIN)) {
            methodInvocation.invoke();
        } else {
            throw new UserPermissionException("You must be an administrator to access this resource.");
        }
    }
}